package com.andaily.hb.infrastructure.jpa;

import com.andaily.hb.domain.network.NetworkInstance;
import com.andaily.hb.infrastructure.AbstractRepositoryTest;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

import static org.junit.jupiter.api.Assertions.*;

/**
 * 2023/12/13 11:00
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
@Transactional
class NetworkInstanceRepositoryTest extends AbstractRepositoryTest {


    @Autowired
    private NetworkInstanceRepository instanceRepository;


    @Test
    void testEntity() {

        List<NetworkInstance> list = instanceRepository.findAll();
        assertTrue(list.isEmpty());

    }

    @Test
    void findHadLogPublicInstances() {

        List<NetworkInstance> list = instanceRepository.findHadLogPublicInstances();
        assertTrue(list.isEmpty());
    }
    @Test
    void findHadLogInstances() {

        List<NetworkInstance> list = instanceRepository.findHadLogInstances();
        assertTrue(list.isEmpty());
    }

    @Test
    void countByGuid() {

        int count = instanceRepository.countByGuid("guidxxxx");
        assertEquals(0, count);
    }

}