package com.andaily.hb.infrastructure.jpa;

import com.andaily.hb.infrastructure.AbstractRepositoryTest;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;

import static com.andaily.hb.infrastructure.DateUtils.now;
import static org.junit.jupiter.api.Assertions.*;

/**
 * 2023/11/22 15:57
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
class MonitoringReminderLogRepositoryTest extends AbstractRepositoryTest {

    @Autowired
    private MonitoringReminderLogRepository logRepository;

    @Test
    void findByGuid() {

        assertNull(logRepository.findByGuid("123"));
    }

    @Test
    void deleteNetworkInstanceLogs() {

        int row = logRepository.deleteNetworkInstanceLogs("123");
        assertEquals(0, row);
    }

    @Test
    void totalMonitoringReminderLogs() {

        assertEquals(0, logRepository.totalMonitoringReminderLogs("123"));

    }

    @Test
    void amountOfMonitoringReminderLogs() {

        assertEquals(0, logRepository.amountOfMonitoringReminderLogs("123", true));
    }

    @Test
    void amountOfMonitoringReminderLogsBeforeDate() {

        assertEquals(0, logRepository.amountOfMonitoringReminderLogsBeforeDate(System.currentTimeMillis()));
    }

    @Test
    void deleteMonitoringReminderLogsBeforeDate() {

        assertEquals(0, logRepository.deleteMonitoringReminderLogsBeforeDate(now()));
    }
}