package com.andaily.hb.infrastructure.jpa;

import com.andaily.hb.domain.log.FrequencyMonitorLog;
import com.andaily.hb.infrastructure.AbstractRepositoryTest;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.List;

import static com.andaily.hb.infrastructure.DateUtils.now;
import static org.junit.jupiter.api.Assertions.*;

/**
 * 2023/11/22 15:39
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
class FrequencyMonitorLogRepositoryTest extends AbstractRepositoryTest {


    @Autowired
    private FrequencyMonitorLogRepository logRepository;


    @Test
    void findFirstMonitoringLogTime() {

        Date date = logRepository.findFirstMonitoringLogTime("1234567890", true);
        assertNull(date);
    }

    @Test
    void findNetworkFrequencyMonitorLogs() {

        List<FrequencyMonitorLog> list = logRepository.findNetworkFrequencyMonitorLogs("1234567890", new Date());
        assertTrue(list.isEmpty());
    }

    @Test
    void deleteNetworkInstanceLogs() {

        int row = logRepository.deleteNetworkInstanceLogs("1234567890");
        assertEquals(0, row);
    }

    @Test
    void amountOfFrequencyMonitorLogsBeforeDate() {

        long l = logRepository.amountOfFrequencyMonitorLogsBeforeDate(now());
        assertEquals(0, l);
    }

    @Test
    void amountOfInstanceMonitorLogs() {

        int a = logRepository.amountOfInstanceMonitorLogs("1234567890", true);
        assertEquals(0, a);
    }

    @Test
    void findLastNotNormalFrequencyMonitorLog() {

        FrequencyMonitorLog log = logRepository.findLastNotNormalFrequencyMonitorLog("1234567890", now());
        assertNull(log);
    }

    @Test
    void findFrequencyMonitorLogs() {

        List<FrequencyMonitorLog> list = logRepository.findFrequencyMonitorLogs("1234567890", new Date());
        assertTrue(list.isEmpty());
    }

    @Test
    void findFirstMonitoringLogTimeAfterSpecifyTime() {

        Date date = logRepository.findFirstMonitoringLogTimeAfterSpecifyTime("1234567890", new Date());
        assertNull(date);

    }

}