package com.andaily.hb.infrastructure.jpa;

import com.andaily.hb.domain.application.ApplicationInstance;
import com.andaily.hb.domain.application.ApplicationInstanceURL;
import com.andaily.hb.domain.application.InstanceMonitorURLParameter;
import com.andaily.hb.domain.log.FrequencyMonitorLog;
import com.andaily.hb.domain.log.MonitoringReminderLog;
import com.andaily.hb.domain.shared.GuidGenerator;
import com.andaily.hb.infrastructure.AbstractRepositoryTest;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

import static org.junit.jupiter.api.Assertions.*;

/**
 * 2023/11/21 19:34
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
@Transactional
class ApplicationInstanceRepositoryJpaTest extends AbstractRepositoryTest {


    @Autowired
    private ApplicationInstanceRepositoryJpa repositoryJpa;

    @Autowired
    private MonitoringReminderLogRepository reminderLogRepository;

    @Autowired
    private FrequencyMonitorLogRepository monitorLogRepository;

    @Test
    void findHadLogInstances() {

        List<ApplicationInstance> list = repositoryJpa.findHadLogInstances();
        assertTrue(list.isEmpty());

    }

    @Test
    void findHadLogPublicInstancesByEnabled() {

        List<ApplicationInstance> list = repositoryJpa.findHadLogPublicInstancesByEnabled(true);
        assertTrue(list.isEmpty());

    }

    @Test
    void findHadLogInstancesByEnabled() {

        List<ApplicationInstance> list = repositoryJpa.findHadLogInstancesByEnabled(true);
        assertTrue(list.isEmpty());

    }

    @Test
    void findHadLogPublicInstances() {

        List<ApplicationInstance> list = repositoryJpa.findHadLogPublicInstances();
        assertTrue(list.isEmpty());

    }

    @Test
    void findByGuid() {

        ApplicationInstance instance = repositoryJpa.findByGuid("guid");
        assertNull(instance);
    }

    @Test
    void findAllEnabledInstances() {
        ApplicationInstance applicationInstance = new ApplicationInstance()
                .instanceName("Andaily");
        repositoryJpa.save(applicationInstance);

        fullClean();

        List<ApplicationInstance> list = repositoryJpa.findAllEnabledInstances();
        assertEquals(0, list.size());
    }

    @Test
    void deleteInstanceFrequencyMonitorLogs() {
        ApplicationInstance applicationInstance = new ApplicationInstance()
                .instanceName("Andaily");
        repositoryJpa.save(applicationInstance);

        FrequencyMonitorLog monitorLog = new FrequencyMonitorLog()
                .instance(applicationInstance);
        monitorLogRepository.save(monitorLog);

        fullClean();

        final int count = repositoryJpa.deleteInstanceFrequencyMonitorLogs(applicationInstance.guid());
        assertEquals(count, 1);


    }

    @Test
    void deleteInstanceMonitoringReminderLogs() {

        ApplicationInstance applicationInstance = new ApplicationInstance()
                .instanceName("Andaily");
        repositoryJpa.save(applicationInstance);

        FrequencyMonitorLog monitorLog = new FrequencyMonitorLog()
                .instance(applicationInstance);
        monitorLogRepository.save(monitorLog);

        MonitoringReminderLog reminderLog = new MonitoringReminderLog()
                .instance(applicationInstance);
        reminderLogRepository.save(reminderLog);

        fullClean();

        final int count = repositoryJpa.deleteInstanceMonitoringReminderLogs(applicationInstance.guid());
        assertEquals(count, 1);


    }

    @Test
    void deleteApplicationInstanceWeixinUsers() {


        ApplicationInstance instance = new ApplicationInstance()
                .instanceName("Andaily");
        repositoryJpa.save(instance);

        ApplicationInstance byGuid = repositoryJpa.findByGuid(instance.guid());

        final int i = repositoryJpa.deleteApplicationInstanceWeixinUsers(byGuid);
        assertEquals(i, 0);
    }

    @Test
    void testInstanceMonitorURLParameter() {
        ApplicationInstance instance = new ApplicationInstance()
                .instanceName("Andaily");

        final InstanceMonitorURLParameter parameter = new InstanceMonitorURLParameter()
                .key("guid").value(GuidGenerator.generate()).instance(instance);
        instance.addMonitorURLParameter(parameter);

        final InstanceMonitorURLParameter parameter2 = new InstanceMonitorURLParameter()
                .key("name").value("odedd").instance(instance);
        instance.addMonitorURLParameter(parameter2);

        repositoryJpa.save(instance);

        fullClean();

        final ApplicationInstance instance1 = repositoryJpa.findByGuid(instance.guid());
        assertNotNull(instance1);
        final ApplicationInstanceURL url = instance1.instanceURL();
        assertNotNull(url);

        final List<InstanceMonitorURLParameter> parameters = url.urlParameters();
        assertEquals(parameters.size(), 2);

        final InstanceMonitorURLParameter parameter1 = parameters.get(0);
        assertNotNull(parameter1);
        assertNotNull(parameter1.key());
        assertNotNull(parameter1.value());
        assertNotNull(parameter1.instance());

    }
}