package com.andaily.hb.infrastructure;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

/**
 * 2023/12/29 12:28
 * <p>
 * 模拟 UDP Server 接收数据， 测试
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
public class SocketUdpServerMock {

    private static final Logger LOG = LoggerFactory.getLogger(SocketUdpServerMock.class);


    public static void main(String[] args) throws Exception {

        int port = 13458;

        try (DatagramSocket socket = new DatagramSocket(port)) {
//            System.out.println("UDP Server is running on port " + port);
            LOG.info("UDP Server is running on port {}", port);

            int threadCount = 0;
            while (threadCount < 10000) {
                threadCount++;
                byte[] receiveData = new byte[1024];
                DatagramPacket receivePacket = new DatagramPacket(receiveData, receiveData.length);

                // 接收客户端数据
                socket.receive(receivePacket);
                String data = new String(receivePacket.getData(), 0, receivePacket.getLength());
//                System.out.println("Received from client: " + data);
                LOG.info("Received from client: {}", data);

                // 向客户端发送响应
                InetAddress clientAddress = receivePacket.getAddress();
                int clientPort = receivePacket.getPort();
                byte[] sendData = "OK,UDP!".getBytes();
                DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, clientAddress, clientPort);
                socket.send(sendPacket);
            }
        }
    }
}
