package com.andaily.hb.infrastructure;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

/**
 * 2023/12/29 12:28
 * <p>
 * 模拟 TCP Server 接收数据， 测试
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
public class SocketTcpServerMock {

    private static final Logger LOG = LoggerFactory.getLogger(SocketTcpServerMock.class);

    public static void main(String[] args) throws Exception {

        int port = 13456;

        try (ServerSocket serverSocket = new ServerSocket(port)) {
//            System.out.println("TCP Server is running on port " + port);
            LOG.info("TCP Server is running on port {}", port);

            int threadCount = 0;
            while (threadCount < 10000) {
                threadCount++;
                Socket socket = serverSocket.accept();

                // 新建线程处理客户端连接
                new Thread(() -> {
                    try {
                        // 读取客户端数据
                        BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                        String data = reader.readLine();
//                        System.out.println("Received from client: " + data);
                        LOG.info("Received from client: {}", data);

                        // 向客户端发送响应
                        OutputStream out = socket.getOutputStream();
                        out.write("OK!".getBytes());

                        // 关闭连接
                        socket.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }

                }).start();
            }
        }


    }
}
