package com.andaily.hb.web.controller;

import com.andaily.hb.domain.dto.network.NetworkInstanceFormDto;
import com.andaily.hb.domain.dto.network.NetworkInstanceListDto;
import com.andaily.hb.service.NetworkInstanceService;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

/**
 * 2023/12/13 20:30
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
@Controller
@RequestMapping("/network_instance/")
public class NetworkInstanceController {


    @Autowired
    private NetworkInstanceService instanceService;


    /**
     * list  network instance
     */
    @GetMapping("list.hb")
    public String list(NetworkInstanceListDto listDto, Model model) {
        instanceService.loadNetworkInstanceListDto(listDto);
        model.addAttribute("listDto", listDto);
        return "network_instance/instance_list";
    }

    /**
     * Enable newly instance
     */
    @GetMapping("enable.hb")
    public String enableInstance(@RequestParam String guid, RedirectAttributes model) {
        final boolean result = instanceService.enableNetworkInstance(guid);
        model.addAttribute("alert", result ? "enableSuccess" : "enableFailed")
                .addAttribute("enabled", true);
        return "redirect:list.hb";
    }

    /**
     * Stop monitoring instance
     */
    @GetMapping("stop.hb")
    public String stopInstance(@RequestParam String guid, String enabled, RedirectAttributes model) {
        final boolean result = instanceService.stopMonitoringNetworkInstance(guid);
        model.addAttribute("alert", result ? "stopSuccess" : "stopFailed")
                .addAttribute("enabled", enabled);
        return "redirect:list.hb";
    }

    /**
     * Delete instance
     */
    @GetMapping("delete.hb")
    public String deleteInstance(@RequestParam String guid, RedirectAttributes model) {
        final boolean result = instanceService.deleteNetworkInstance(guid);
        model.addAttribute("alert", result ? "deleteSuccess" : "deleteFailed");
        return "redirect:list.hb";
    }

    /**
     * New/Edit instance: Network
     */
    @GetMapping("instance_form.hb")
    public String loadForm(String guid, Model model) {
        NetworkInstanceFormDto formDto = instanceService.loadNetworkInstanceFormDto(guid);
        model.addAttribute("formDto", formDto);
        return "network_instance/instance_form";
    }

    @PostMapping("instance_form.hb")
    public String submitForm(@ModelAttribute("formDto") @Valid NetworkInstanceFormDto formDto, BindingResult result, RedirectAttributes model) {
        if (result.hasErrors()) {
            return "network_instance/instance_form";
        }
        instanceService.persistNetworkInstance(formDto);
        model.addAttribute("alert", "saveInstanceOK");
        return "redirect:list.hb";
    }


}
