package com.andaily.hb.web.controller;

import com.andaily.hb.domain.dto.log.FrequencyMonitorLogListDto;
import com.andaily.hb.domain.dto.log.ReminderLogListDto;
import com.andaily.hb.service.LogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.Arrays;

/**
 * 15-2-13
 *
 * @author Shengzhao Li
 */
@Controller
@RequestMapping("log/")
public class LogController {


    @Autowired
    private LogService logService;


    /**
     * 监控日志
     */
    @RequestMapping("list.hb")
    public String listLogs(FrequencyMonitorLogListDto listDto, Model model) {
        logService.loadFrequencyMonitorLogListDto(listDto);
        model.addAttribute("listDto", listDto);
        return "log/log_list";
    }


    /**
     * 提醒日志
     */
    @RequestMapping("reminder_list.hb")
    public String reminderLogs(ReminderLogListDto listDto, Model model) {
        logService.loadReminderLogListDto(listDto);
        model.addAttribute("listDto", listDto);

        model.addAttribute("normalOptions",
                Arrays.asList(new NormalOption(-1, "所有状态变化"),
                        new NormalOption(0, "正常 -> 不正常"),
                        new NormalOption(1, "不正常 -> 正常")));
        return "log/reminder_logs";
    }

    /**
     * @since 3.0.0
     */
    private static class NormalOption {
        int value;
        String label;

        public NormalOption(int value, String label) {
            this.value = value;
            this.label = label;
        }

        public int getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }
    }

}
