package com.andaily.hb.web.controller;

import com.andaily.hb.domain.dto.notify.EmailConfigFormDto;
import com.andaily.hb.domain.dto.notify.EmailConfigTestResult;
import com.andaily.hb.service.EmailConfigService;
import com.andaily.hb.web.WebUtils;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import java.util.StringJoiner;

/**
 * 2023/12/4 12:16
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
@Controller
@RequestMapping("/system/email/")
public class EmailConfigController {


    @Autowired
    private EmailConfigService configService;


    /**
     * 加载邮件配置
     */
    @GetMapping("setting.hb")
    public String loadSetting(Model model) {
        EmailConfigFormDto formDto = configService.loadEmailConfigFormDto();
        model.addAttribute("formDto", formDto);
        return "notify/email_setting";
    }


    /**
     * 保存邮件配置
     */
    @PostMapping("setting.hb")
    public String submitForm(@ModelAttribute("formDto") @Valid EmailConfigFormDto formDto, BindingResult result, RedirectAttributes model) {
        if (result.hasErrors()) {
            return "notify/email_setting";
        }
        configService.saveEmailConfig(formDto);
        model.addAttribute("alert", "saveEmailConfigOk");
        return "redirect:setting.hb";
    }


    /**
     * 测试邮件配置
     */
    @PostMapping("test_setting.hb")
    public void test(@Valid EmailConfigFormDto formDto, BindingResult result, HttpServletResponse response) {
        if (result.hasErrors()) {
            StringJoiner sj = new StringJoiner(",");
            result.getAllErrors().forEach(error -> {
                sj.add(error.getDefaultMessage());
            });
            WebUtils.writeJson(response, JSONObject.fromObject(new EmailConfigTestResult(false, sj.toString())));
        } else {
            EmailConfigTestResult testResult = configService.testEmailConfig(formDto);
            WebUtils.writeJson(response, JSONObject.fromObject(testResult));
        }
    }


}
