package com.andaily.hb.web.controller;

import com.andaily.hb.domain.dto.notify.DingtalkRobotConfigFormDto;
import com.andaily.hb.service.DingtalkRobotConfigService;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

/**
 * 2024/1/8 12:16
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
@Controller
@RequestMapping("/system/dingtalk_robot/")
public class DingtalkRobotConfigController {


    @Autowired
    private DingtalkRobotConfigService configService;


    /**
     * 加载配置
     */
    @GetMapping("setting.hb")
    public String loadSetting(Model model) {
        DingtalkRobotConfigFormDto formDto = configService.loadDingtalkRobotConfigForm();
        model.addAttribute("formDto", formDto);
        return "notify/dingtalk_robot_setting";
    }


    /**
     * 保存配置
     */
    @PostMapping("setting.hb")
    public String submitForm(@ModelAttribute("formDto") @Valid DingtalkRobotConfigFormDto formDto, BindingResult result, RedirectAttributes model) {
        if (result.hasErrors()) {
            return "notify/dingtalk_robot_setting";
        }
        configService.saveDingtalkRobotConfig(formDto);
        model.addAttribute("alert", "saveConfigOk");
        return "redirect:setting.hb";
    }


}
