package com.andaily.hb.web.context;

import com.andaily.hb.domain.dto.user.UserRegisterDto;
import com.andaily.hb.web.WebUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.HandlerInterceptor;


import static org.springframework.web.bind.ServletRequestUtils.getStringParameter;

/**
 * 15-4-27
 * <p/>
 * 注册用户时的  验证码 拦截器
 *
 * @author Shengzhao Li
 */
public class RegisterUserInterceptor implements HandlerInterceptor {


    public RegisterUserInterceptor() {
    }

    /**
    * For validate captcha
    * */
    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (RequestMethod.GET.name().equalsIgnoreCase(request.getMethod())) {
            return true;
        }

        final String correctCaptcha = WebUtils.getCaptchaKey(request.getSession());
        final String captcha = getStringParameter(request, UserRegisterDto.CAPTCHA_KEY);

        if (StringUtils.isEmpty(captcha) || !captcha.equalsIgnoreCase(correctCaptcha)) {
            response.getWriter().print("<script>alert('Invalid Captcha.');history.back();</script>");
            return false;
        }

        return true;
    }

}
