package com.andaily.hb.web.context;

import com.andaily.hb.infrastructure.ThreadLocalHolder;
import com.andaily.hb.web.WebUtils;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.web.filter.CharacterEncodingFilter;


import java.io.IOException;

/**
 * Wrap the spring <i>CharacterEncodingFilter</i>, add retrieve client ip action
 * <p/>
 * <p/>
 * 扩展 默认的 CharacterEncodingFilter, 添加对IP 地址的获取
 *
 * @author Shengzhao Li
 */
public class HBCharacterEncodingFilter extends CharacterEncodingFilter {


    @Override
    protected void doFilterInternal(
            HttpServletRequest request, HttpServletResponse response, FilterChain filterChain)
            throws ServletException, IOException {

        persistIp(request);
        super.doFilterInternal(request, response, filterChain);

    }

    /**
     * 将IP地址 放置在 ThreadLocal 中
     */
    private void persistIp(HttpServletRequest request) {
        final String clientIp = WebUtils.retrieveClientIp(request);
        ThreadLocalHolder.clientIp(clientIp);
    }


}