package com.andaily.hb.service.operation.user;

import com.andaily.hb.domain.dto.user.UserFormDto;
import com.andaily.hb.domain.shared.BeanProvider;
import com.andaily.hb.domain.shared.security.SecurityUtils;
import com.andaily.hb.domain.user.Privilege;
import com.andaily.hb.domain.user.User;
import com.andaily.hb.domain.user.UserPrivilege;
import com.andaily.hb.infrastructure.jpa.UserPrivilegeRepository;
import com.andaily.hb.infrastructure.jpa.UserRepositoryJpa;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * 15-4-12
 * <p/>
 * 用户的添加/更新 业务处理
 *
 * @author Shengzhao Li
 */
public class UserFormDtoPersister {

    private static final Logger LOGGER = LoggerFactory.getLogger(UserFormDtoPersister.class);

    private final transient UserRepositoryJpa userRepository = BeanProvider.getBean(UserRepositoryJpa.class);

    /**
     * @since 3.0.0
     */
    private final transient UserPrivilegeRepository userPrivilegeRepository = BeanProvider.getBean(UserPrivilegeRepository.class);

    private final UserFormDto formDto;

    public UserFormDtoPersister(UserFormDto formDto) {
        this.formDto = formDto;
    }

    public String persist() {
        if (formDto.isNewly()) {
            return createUser();
        } else {
            return updateUser();
        }
    }

    private String updateUser() {
        User user = userRepository.findByGuid(formDto.getGuid());
        user.username(formDto.getUsername())
                .phone(formDto.getPhone())
                .email(formDto.getEmail());

        updatePrivileges(user, false);
        LOGGER.debug("<{}> update User: {}", SecurityUtils.currentUsername(), user);
        return user.guid();
    }

    private String createUser() {
        User user = formDto.toDomain()
                .creator(SecurityUtils.currentUser());
        userRepository.save(user);

        updatePrivileges(user, true);
        LOGGER.debug("<{}> create User: {}", SecurityUtils.currentUsername(), user);
        return user.guid();
    }

    private void updatePrivileges(User user, boolean newly) {
        if (!newly) {
            //清除旧数据
            List<UserPrivilege> userPrivileges = userRepository.findUserPrivileges(user);
            userPrivilegeRepository.deleteAll(userPrivileges);
        }

        for (Privilege privilege : formDto.getPrivileges()) {
            UserPrivilege userPrivilege = new UserPrivilege(user, privilege);
            userPrivilegeRepository.save(userPrivilege);
        }
    }
}
