package com.andaily.hb.service.operation.user;

import com.andaily.hb.domain.dto.user.SystemSettingDto;
import com.andaily.hb.domain.shared.Application;
import com.andaily.hb.domain.shared.BeanProvider;
import com.andaily.hb.domain.shared.security.SecurityUtils;
import com.andaily.hb.domain.user.SystemSetting;
import com.andaily.hb.infrastructure.jpa.SystemSettingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 15-4-14
 * <p/>
 * 系统设置
 *
 * @author Shengzhao Li
 */
public class SystemSettingUpdater {

    private static final Logger LOGGER = LoggerFactory.getLogger(SystemSettingUpdater.class);

    private final transient SystemSettingRepository settingRepository = BeanProvider.getBean(SystemSettingRepository.class);
    private final SystemSettingDto settingDto;

    public SystemSettingUpdater(SystemSettingDto settingDto) {
        this.settingDto = settingDto;
    }

    public void update() {
        SystemSetting setting = settingRepository.findSystemSetting();
        if (setting == null) {
            setting = new SystemSetting();
        }

        setting.allowUserRegister(settingDto.isAllowUserRegister());
        setting.cleanMonitorLogFrequency(settingDto.getCleanMonitorLogFrequency());

        setting.proxyEnabled(settingDto.isProxyEnabled())
                .proxyHost(settingDto.getProxyHost())
                .proxyPort(settingDto.getProxyPort());
        //Be sure call saveOrUpdate
        settingRepository.save(setting);
        LOGGER.debug("<{}> update system setting: {}", SecurityUtils.currentUsername(), setting);

        //update global setting
        updateGlobalSetting(setting);
    }

    private void updateGlobalSetting(SystemSetting setting) {
        Application.systemSetting()
                .proxyPort(setting.proxyPort())
                .proxyHost(setting.proxyHost())
                .proxyEnabled(setting.proxyEnabled())
                .allowUserRegister(setting.allowUserRegister())
                .cleanMonitorLogFrequency(setting.cleanMonitorLogFrequency());
    }
}
