package com.andaily.hb.service.operation.user;

import com.andaily.hb.domain.dto.user.SystemSettingDto;
import com.andaily.hb.domain.shared.BeanProvider;
import com.andaily.hb.domain.user.SystemSetting;
import com.andaily.hb.infrastructure.DateUtils;
import com.andaily.hb.infrastructure.jpa.FrequencyMonitorLogRepository;
import com.andaily.hb.infrastructure.jpa.SystemSettingRepository;

/**
 * 2017/1/21
 *
 * @author Shengzhao Li
 */
public class SystemSettingDtoLoader {

    private final transient SystemSettingRepository settingRepository = BeanProvider.getBean(SystemSettingRepository.class);
    private final transient FrequencyMonitorLogRepository logRepository = BeanProvider.getBean(FrequencyMonitorLogRepository.class);


    public SystemSettingDtoLoader() {
    }

    public SystemSettingDto load() {

        SystemSetting systemSetting = settingRepository.findSystemSetting();
        if (systemSetting == null) {
            systemSetting = new SystemSetting();
        }
        final SystemSettingDto settingDto = new SystemSettingDto(systemSetting);

        final long amount = logRepository.amountOfFrequencyMonitorLogsBeforeDate(DateUtils.now());
        settingDto.setMonitorLogAmount(amount);

        return settingDto;
    }
}
