package com.andaily.hb.service.operation.user;

import com.andaily.hb.domain.dto.user.UserRegisterDto;
import com.andaily.hb.domain.shared.BeanProvider;
import com.andaily.hb.domain.user.Privilege;
import com.andaily.hb.domain.user.User;
import com.andaily.hb.domain.user.UserPrivilege;
import com.andaily.hb.infrastructure.ThreadLocalHolder;
import com.andaily.hb.infrastructure.jpa.UserPrivilegeRepository;
import com.andaily.hb.infrastructure.jpa.UserRepositoryJpa;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * 处理注册用户
 *
 * @author Shengzhao Li
 */
public class RegisterUserHandler {

    private static final Logger LOG = LoggerFactory.getLogger(RegisterUserHandler.class);

    private final transient UserRepositoryJpa userRepository = BeanProvider.getBean(UserRepositoryJpa.class);

    /**
     * @since 3.0.0
     */
    private final transient UserPrivilegeRepository userPrivilegeRepository = BeanProvider.getBean(UserPrivilegeRepository.class);


    private final UserRegisterDto formDto;

    public RegisterUserHandler(UserRegisterDto formDto) {
        this.formDto = formDto;
    }

    public void handle() {
        User newUser = formDto.toDomain();
        userRepository.save(newUser);

        addDefaultPrivileges(newUser);
        LOG.debug("[{}] register a new User: {}", ThreadLocalHolder.clientIp(), newUser);
    }

    private void addDefaultPrivileges(User newUser) {
        final List<Privilege> privileges = Privilege.registeredUserPrivileges();
        for (Privilege privilege : privileges) {
            UserPrivilege userPrivilege = new UserPrivilege(newUser, privilege);
            userPrivilegeRepository.save(userPrivilege);
        }
    }
}