package com.andaily.hb.service.operation.search;

import com.andaily.hb.domain.dto.HBSearchDto;
import com.andaily.hb.domain.dto.HBSearchResultDto;
import com.andaily.hb.domain.log.FrequencyMonitorLog;
import com.andaily.hb.domain.shared.BeanProvider;
import com.andaily.hb.infrastructure.MatchUtils;
import com.andaily.hb.infrastructure.jpa.FrequencyMonitorLogRepository;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.domain.Specification;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 15-3-13
 * <p/>
 * 监控日志的 搜索业务
 *
 * @author Shengzhao Li
 */
public class MonitorLogSearcher implements HBSearcher {

    private final transient FrequencyMonitorLogRepository logRepository = BeanProvider.getBean(FrequencyMonitorLogRepository.class);

    public MonitorLogSearcher() {
    }

    @Override
    public HBSearchDto search(HBSearchDto searchDto) {
        final Map<String, Object> map = searchDto.queryMap();
        PageRequest pageRequest = PageRequest.of(searchDto.getPageNumber(), searchDto.getPerPageSize());
        Page<FrequencyMonitorLog> aPage = logRepository.findAll((Specification<FrequencyMonitorLog>) (root, query, criteriaBuilder) -> {
            List<Predicate> predicates = new ArrayList<>();
            //查询条件 see HBSearchMonitorLogsQueryHelper
            final String key = (String) map.get("key");
            final boolean positiveNumber = MatchUtils.isPositiveNumber(key);
            List<Predicate> orPredicates = new ArrayList<>();
            orPredicates.add(criteriaBuilder.like(root.get("instance").get("instanceName"), "%" + key + "%"));
            orPredicates.add(criteriaBuilder.like(root.get("remark"), "%" + key + "%"));

            if (positiveNumber) {
                Long keyLong = Long.valueOf(key);
                orPredicates.add(criteriaBuilder.equal(root.get("costTime"), keyLong));
                orPredicates.add(criteriaBuilder.equal(root.get("responseSize"), keyLong));
            }
            predicates.add(criteriaBuilder.or(orPredicates.toArray(new Predicate[0])));

            predicates.add(criteriaBuilder.equal(root.get("archived"), false));
            //sort
            Order order = criteriaBuilder.desc(root.get("createTime"));
            return query.where(predicates.toArray(new Predicate[0])).orderBy(order).getRestriction();
        }, pageRequest);

        List<HBSearchResultDto> dtos = HBSearchResultDto.toMonitorLogDtos(aPage.getContent());
        return searchDto.load(aPage.getTotalElements(), dtos);
    }
}
