package com.andaily.hb.service.operation.search;

import com.andaily.hb.domain.dto.HBSearchDto;
import org.apache.commons.lang.StringUtils;


/**
 * 15-3-13
 * <p/>
 * 处理头部的 搜索
 *
 * @author Shengzhao Li
 */
public class HBSearchDtoLoader {
    private final HBSearchDto searchDto;

    public HBSearchDtoLoader(HBSearchDto searchDto) {
        this.searchDto = searchDto;
    }

    public HBSearchDto load() {
        //Ignore empty key
        if (StringUtils.isEmpty(searchDto.getKey())) {
            return searchDto;
        }
        final HBSearcher hbSearcher = searchDto.getSearchType().resolveSearcher();
        return hbSearcher.search(searchDto);
    }
}
