package com.andaily.hb.service.operation.search;

import com.andaily.hb.domain.application.ApplicationInstance;
import com.andaily.hb.domain.dto.HBSearchDto;
import com.andaily.hb.domain.dto.HBSearchResultDto;
import com.andaily.hb.domain.shared.BeanProvider;
import com.andaily.hb.domain.shared.security.SecurityUtils;
import com.andaily.hb.infrastructure.MatchUtils;
import com.andaily.hb.infrastructure.jpa.ApplicationInstanceRepositoryJpa;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.domain.Specification;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 15-3-13
 * <p/>
 * 应用实例的 搜索业务处理
 *
 * @author Shengzhao Li
 */
public class ApplicationInstanceSearcher implements HBSearcher {

    private final transient ApplicationInstanceRepositoryJpa instanceRepository = BeanProvider.getBean(ApplicationInstanceRepositoryJpa.class);

    public ApplicationInstanceSearcher() {
    }

    @Override
    public HBSearchDto search(HBSearchDto searchDto) {

        final Map<String, Object> map = searchDto.queryMap();
        //page 从0开始
        PageRequest page = PageRequest.of(searchDto.getPageNumber(), searchDto.getPerPageSize());
        Page<ApplicationInstance> aPage = instanceRepository.findAll((Specification<ApplicationInstance>) (root, query, criteriaBuilder) -> {
            List<Predicate> predicates = new ArrayList<>();
            //查询条件   see HBSearchInstancesQueryHelper
            final String key = (String) map.get("key");
            final boolean positiveNumber = MatchUtils.isPositiveNumber(key);
            List<Predicate> orPredicates = new ArrayList<>();
            orPredicates.add(criteriaBuilder.like(root.get("instanceName"), "%" + key + "%"));
            orPredicates.add(criteriaBuilder.like(root.get("email"), "%" + key + "%"));
            //关联查询
            Join<Object, Object> instanceUrlJoin = root.join("instanceURL");
            orPredicates.add(criteriaBuilder.like(instanceUrlJoin.get("monitorUrl"), "%" + key + "%"));
            if (positiveNumber) {
                orPredicates.add(criteriaBuilder.equal(root.get("maxConnectionSeconds"), Integer.valueOf(key)));
            }
            predicates.add(criteriaBuilder.or(orPredicates.toArray(new Predicate[0])));


            if (SecurityUtils.currentUser() == null) {
                predicates.add(criteriaBuilder.equal(root.get("privateInstance"), false));
//                return " and ai.privateInstance = false ";
            }

            predicates.add(criteriaBuilder.equal(root.get("archived"), false));
            //sort
            Order order = criteriaBuilder.desc(root.get("createTime"));
            return query.where(predicates.toArray(new Predicate[0])).orderBy(order).getRestriction();
        }, page);

        List<HBSearchResultDto> dtos = HBSearchResultDto.toInstanceDtos(aPage.getContent());
        return searchDto.load(aPage.getTotalElements(), dtos);
    }
}
