package com.andaily.hb.service.operation.network;

import com.andaily.hb.domain.dto.network.NetworkInstanceFormDto;
import com.andaily.hb.domain.network.NetworkInstance;
import com.andaily.hb.domain.shared.security.SecurityUtils;
import com.andaily.hb.infrastructure.jpa.NetworkInstanceRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 2023-12-28
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
@Component
public class NetworkInstanceFormPersister {

    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkInstanceFormPersister.class);

    @Autowired
    private NetworkInstanceRepository instanceRepository;


    private NetworkInstanceFormDto formDto;

    public NetworkInstanceFormPersister() {
    }

    public void persist(NetworkInstanceFormDto formDto) {
        this.formDto = formDto;
        if (formDto.isNewly()) {
            createInstance();
        } else {
            updateInstance();
        }
    }

    private void updateInstance() {
        NetworkInstance instance = instanceRepository.findByGuid(formDto.getGuid());
        if (instance.enabled()) {
            throw new IllegalStateException("Only Disabled NetworkInstance support edit");
        }

        setFields(instance);
        instanceRepository.save(instance);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("<{}> Update NetworkInstance [{}]", SecurityUtils.currentUsername(), instance);
        }
    }

    private void createInstance() {
        NetworkInstance instance = new NetworkInstance()
                .type(formDto.getType())
                .creator(SecurityUtils.currentUser());
        setFields(instance);

        instanceRepository.save(instance);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("<{}> Create NetworkInstance [{}]", SecurityUtils.currentUsername(), instance);
        }
    }


    private void setFields(NetworkInstance instance) {
        instance
                .instanceName(formDto.getInstanceName())
                .maxConnectionSeconds(formDto.getMaxConnectionSeconds())
                .privateInstance(formDto.isPrivateInstance())
                .continueFailedTimes(formDto.getContinueFailedTimes())
                .useProxy(formDto.isUseProxy())
                .frequency(formDto.getFrequency())
                .remark(formDto.getRemark())

                .email(formDto.getEmail())
                .groupId(formDto.getGroupId())
                .serverAddress(formDto.getServerAddress())
                .serverPort(formDto.getServerPort())
                .sendContent(formDto.getSendContent());
    }

}
