package com.andaily.hb.service.operation.network;

import com.andaily.hb.domain.network.NetworkInstance;
import com.andaily.hb.domain.shared.security.SecurityUtils;
import com.andaily.hb.infrastructure.jpa.NetworkInstanceRepository;
import com.andaily.hb.infrastructure.scheduler.DynamicJob;
import com.andaily.hb.infrastructure.scheduler.DynamicSchedulerFactory;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 2023-12-28
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
@Component
public class MonitoringNetworkInstanceKiller {

    private static final Logger LOGGER = LoggerFactory.getLogger(MonitoringNetworkInstanceKiller.class);
    @Autowired
    private NetworkInstanceRepository instanceRepository;


    public MonitoringNetworkInstanceKiller() {
    }

    /**
     * 1. Remove the job
     * 2. update instance to enabled=false
     */
    public boolean kill(String guid) {
        final NetworkInstance instance = instanceRepository.findByGuid(guid);
        if (!instance.enabled()) {
            LOGGER.debug("<{}> Expect NetworkInstance[guid={}] enabled=true,but it is false, illegal status",
                    SecurityUtils.currentUsername(), instance.guid());
            return false;
        }

        if (!pauseJob(instance)) {
            LOGGER.debug("<{}> Pause Job[name={}] failed", SecurityUtils.currentUsername(), instance.jobName());
            return false;
        }

        //update
        instance.enabled(false);
        instanceRepository.save(instance);
        LOGGER.debug("<{}> Update NetworkInstance[guid={}] enabled=false", SecurityUtils.currentUsername(), instance.guid());
        return true;
    }

    private boolean pauseJob(NetworkInstance instance) {
        DynamicJob job = new DynamicJob(instance.jobName());
        try {
            return DynamicSchedulerFactory.pauseJob(job);
        } catch (SchedulerException e) {
            LOGGER.error("<{}> Pause [" + job + "] failed", SecurityUtils.currentUsername(), e);
            return false;
        }
    }
}