package com.andaily.hb.service.operation.instance;

import com.andaily.hb.domain.application.ApplicationInstance;
import com.andaily.hb.domain.shared.BeanProvider;
import com.andaily.hb.domain.shared.security.SecurityUtils;
import com.andaily.hb.infrastructure.jpa.ApplicationInstanceRepositoryJpa;
import com.andaily.hb.infrastructure.scheduler.DynamicJob;
import com.andaily.hb.infrastructure.scheduler.DynamicSchedulerFactory;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Shengzhao Li
 */
public class MonitoringApplicationInstanceKiller {

    private static final Logger LOGGER = LoggerFactory.getLogger(MonitoringApplicationInstanceKiller.class);
    private final transient ApplicationInstanceRepositoryJpa instanceRepository = BeanProvider.getBean(ApplicationInstanceRepositoryJpa.class);
    private final String guid;

    public MonitoringApplicationInstanceKiller(String guid) {
        this.guid = guid;
    }

    /**
     * 1. Remove the job
     * 2. update instance to enabled=false
     *
     */
    public boolean kill() {
        final ApplicationInstance instance = instanceRepository.findByGuid(guid);
        if (!instance.enabled()) {
            LOGGER.debug("<{}> Expect ApplicationInstance[guid={}] enabled=true,but it is false, illegal status",
                    SecurityUtils.currentUsername(), instance.guid());
            return false;
        }

        if (!pauseJob(instance)) {
            LOGGER.debug("<{}> Pause Job[name={}] failed", SecurityUtils.currentUsername(), instance.jobName());
            return false;
        }

        //update
        instance.enabled(false);
        LOGGER.debug("<{}> Update ApplicationInstance[guid={}] enabled=false", SecurityUtils.currentUsername(), instance.guid());
        return true;
    }

    private boolean pauseJob(ApplicationInstance instance) {
        DynamicJob job = new DynamicJob(instance.jobName());
        try {
            return DynamicSchedulerFactory.pauseJob(job);
        } catch (SchedulerException e) {
            LOGGER.error("<{}> Pause [" + job + "] failed", SecurityUtils.currentUsername(), e);
            return false;
        }
    }
}