package com.andaily.hb.service.operation.instance;

import com.andaily.hb.domain.application.ApplicationInstance;
import com.andaily.hb.domain.dto.application.ApplicationInstanceDto;
import com.andaily.hb.domain.dto.application.ApplicationInstanceListDto;
import com.andaily.hb.domain.shared.BeanProvider;
import com.andaily.hb.domain.shared.security.SecurityUtils;
import com.andaily.hb.domain.user.User;
import com.andaily.hb.infrastructure.jpa.ApplicationInstanceRepositoryJpa;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import org.apache.commons.lang.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.domain.Specification;

import java.util.ArrayList;
import java.util.List;

/**
 * 2015/9/22
 *
 * @author Shengzhao Li
 */
public class ApplicationInstanceListDtoLoader {

    private final transient ApplicationInstanceRepositoryJpa instanceRepository = BeanProvider.getBean(ApplicationInstanceRepositoryJpa.class);

    private final ApplicationInstanceListDto listDto;

    public ApplicationInstanceListDtoLoader(ApplicationInstanceListDto listDto) {
        this.listDto = listDto;
    }

    public ApplicationInstanceListDto load() {

        //page 从0开始
        PageRequest page = PageRequest.of(listDto.getPageNumber(), listDto.getPerPageSize());
        Page<ApplicationInstance> aPage = instanceRepository.findAll((Specification<ApplicationInstance>) (root, query, criteriaBuilder) -> {
            List<Predicate> predicates = new ArrayList<>();
            //查询条件   see ApplicationInstanceListQueryHelper
            final String enabled = listDto.getEnabled();
            if (StringUtils.isNotEmpty(enabled)) {
                predicates.add(criteriaBuilder.equal(root.get("enabled"), "true".equalsIgnoreCase(enabled)));
            }
            final String email = listDto.getEmail();
            if (StringUtils.isNotEmpty(email)) {
                predicates.add(criteriaBuilder.like(root.get("email"), "%" + email + "%"));
            }
            final String groupId = listDto.getGroupId();
            if (StringUtils.isNotEmpty(groupId)) {
                predicates.add(criteriaBuilder.like(root.get("groupId"), "%" + groupId + "%"));
            }
            if (SecurityUtils.currentUser() == null) {
                predicates.add(criteriaBuilder.equal(root.get("privateInstance"), false));
            }
            final User user = SecurityUtils.currentUser();
            if (user != null && user.registerUser()) {
                predicates.add(criteriaBuilder.equal(root.get("creator"), user));
            }
            final String instanceName = listDto.getInstanceName();
            if (StringUtils.isNotEmpty(instanceName)) {
                predicates.add(criteriaBuilder.like(root.get("instanceName"), "%" + instanceName + "%"));
            }

            predicates.add(criteriaBuilder.equal(root.get("archived"), false));
            //sort
            Order order = criteriaBuilder.desc(root.get("createTime"));
            return query.where(predicates.toArray(new Predicate[0])).orderBy(order).getRestriction();
        }, page);

        List<ApplicationInstanceDto> dtos = ApplicationInstanceDto.toDtos(aPage.getContent());
        listDto.load(aPage.getTotalElements(), dtos);

        return listDto;
    }
}
