package com.andaily.hb.service.operation.instance;

import com.andaily.hb.domain.application.ApplicationInstance;
import com.andaily.hb.domain.shared.BeanProvider;

import static com.andaily.hb.domain.shared.security.SecurityUtils.currentUsername;

import com.andaily.hb.infrastructure.jpa.ApplicationInstanceRepositoryJpa;
import com.andaily.hb.infrastructure.scheduler.DynamicJob;
import com.andaily.hb.infrastructure.scheduler.DynamicSchedulerFactory;
import org.apache.commons.lang3.StringUtils;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Shengzhao Li
 */
public class ApplicationInstanceDeleter {

    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationInstanceDeleter.class);
    private final transient ApplicationInstanceRepositoryJpa instanceRepository = BeanProvider.getBean(ApplicationInstanceRepositoryJpa.class);
    private final String guid;

    public ApplicationInstanceDeleter(String guid) {
        this.guid = guid;
    }

    public boolean delete() {
        final ApplicationInstance instance = instanceRepository.findByGuid(guid);
        if (instance.enabled()) {
            LOGGER.debug("<{}> Forbid delete enabled ApplicationInstance[guid={}]", currentUsername(), instance.guid());
            return false;
        }

        instanceRepository.deleteInstanceFrequencyMonitorLogs(guid);
        instanceRepository.deleteInstanceMonitoringReminderLogs(guid);

        checkAndRemoveJob(instance);

        //logic delete
        instance.archived(true);
        LOGGER.debug("<{}> Archive ApplicationInstance[guid={}] and FrequencyMonitorLogs,MonitoringReminderLogs", currentUsername(), instance.guid());
        return true;
    }

    private void checkAndRemoveJob(ApplicationInstance instance) {
        String jobName = instance.jobName();
        if (StringUtils.isEmpty(jobName)) {
            return;
        }
        DynamicJob job = new DynamicJob(jobName);
        try {
            if (DynamicSchedulerFactory.existJob(job)) {
                final boolean result = DynamicSchedulerFactory.removeJob(job);
                LOGGER.debug("<{}> Remove DynamicJob[{}] result [{}]", currentUsername(), job, result);
            }
        } catch (SchedulerException e) {
            LOGGER.error("<{}> Remove [" + job + "] failed", currentUsername(), e);
        }
    }
}