package com.andaily.hb.service.operation;

import com.andaily.hb.domain.application.ApplicationInstance;
import com.andaily.hb.domain.dto.CommonsInstanceDto;
import com.andaily.hb.domain.dto.log.MonitoringReminderLogDto;
import com.andaily.hb.domain.dto.log.ReminderLogListDto;
import com.andaily.hb.domain.log.MonitoringReminderLog;
import com.andaily.hb.domain.network.NetworkInstance;
import com.andaily.hb.domain.shared.Application;
import com.andaily.hb.domain.shared.security.SecurityUtils;
import com.andaily.hb.infrastructure.jpa.ApplicationInstanceRepositoryJpa;
import com.andaily.hb.infrastructure.jpa.MonitoringReminderLogRepository;
import com.andaily.hb.infrastructure.jpa.NetworkInstanceRepository;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 15-3-14
 *
 * @author Shengzhao Li
 */
@Component
public class ReminderLogListDtoLoader {

    @Autowired
    private MonitoringReminderLogRepository logRepository;

    /**
     * @since 3.0.0
     */
    @Autowired
    private ApplicationInstanceRepositoryJpa instanceRepository;

    /**
     * @since 3.0.0
     */
    @Autowired
    private NetworkInstanceRepository networkInstanceRepository;


    public ReminderLogListDtoLoader() {
    }

    public ReminderLogListDto load(ReminderLogListDto listDto) {
//        loadInstanceDto();
        loadInstanceDtos(listDto);

        listDto.setCleanMonitorLogFrequency(Application.systemSetting().cleanMonitorLogFrequency());

        final Map<String, Object> map = listDto.queryMap();
        PageRequest pageRequest = PageRequest.of(listDto.getPageNumber(), listDto.getPerPageSize());
        Page<MonitoringReminderLog> aPage = logRepository.findAll((Specification<MonitoringReminderLog>) (root, query, criteriaBuilder) -> {
            List<Predicate> predicates = new ArrayList<>();
            //查询条件   see ReminderLogListQueryHelper
            if (SecurityUtils.currentUser() == null) {
                predicates.add(criteriaBuilder.equal(root.get("instance").get("privateInstance"), false));
            }
            final Integer normal = (Integer) map.get("normal");
            if (normal == 0 || normal == 1) {
                predicates.add(criteriaBuilder.equal(root.get("changeNormal"), normal == 1));
            }
            final String instanceGuid = (String) map.get("instanceGuid");
            if (StringUtils.isNotEmpty(instanceGuid)) {
                predicates.add(criteriaBuilder.equal(root.get(listDto.isNetworkInstance() ? "networkInstance" : "instance").get("guid"), instanceGuid));
            } else {
                //限制范围
                predicates.add(criteriaBuilder.isNotNull(root.get(listDto.isNetworkInstance() ? "networkInstance" : "instance")));
            }
            String groupId = listDto.getGroupId();
            if (StringUtils.isNotEmpty(groupId)) {
                predicates.add(criteriaBuilder.like(root.get(listDto.isNetworkInstance() ? "networkInstance" : "instance").get("groupId"), "%" + groupId + "%"));
            }

            predicates.add(criteriaBuilder.equal(root.get("archived"), false));
            //sort
            Order order = criteriaBuilder.desc(root.get("createTime"));
            return query.where(predicates.toArray(new Predicate[0])).orderBy(order).getRestriction();
        }, pageRequest);

        List<MonitoringReminderLogDto> dtos = MonitoringReminderLogDto.toDtosa(aPage.getContent());
        return listDto.load(aPage.getTotalElements(), dtos);
    }

    private void loadInstanceDtos(ReminderLogListDto listDto) {
        List<CommonsInstanceDto> instanceDtos = listDto.getInstanceDtos();
        if (listDto.isNetworkInstance()) {
            List<NetworkInstance> networkInstances;
            if (SecurityUtils.currentUser() == null) {
                networkInstances = networkInstanceRepository.findHadLogPublicInstances();
            } else {
                networkInstances = networkInstanceRepository.findHadLogInstances();
            }
            for (NetworkInstance networkInstance : networkInstances) {
                instanceDtos.add(new CommonsInstanceDto(networkInstance));
            }
        } else {
            List<ApplicationInstance> instances;
            if (SecurityUtils.currentUser() == null) {
                instances = instanceRepository.findHadLogPublicInstances();
            } else {
                instances = instanceRepository.findHadLogInstances();
            }

            for (ApplicationInstance instance : instances) {
                instanceDtos.add(new CommonsInstanceDto(instance));
            }
        }
    }

//    private void loadInstanceDto() {
//        final String instanceGuid = listDto.getInstanceGuid();
//        if (StringUtils.isNotEmpty(instanceGuid)) {
//            final ApplicationInstance instance = instanceRepository.findByGuid(instanceGuid);
//            listDto.setInstanceDto(new ApplicationInstanceDto(instance));
//        }
//    }
}
