package com.andaily.hb.service.operation;

import com.andaily.hb.domain.application.ApplicationInstance;
import com.andaily.hb.domain.dto.MonitoringInstanceDto;
import com.andaily.hb.domain.log.FrequencyMonitorLog;
import com.andaily.hb.domain.network.NetworkInstance;
import com.andaily.hb.infrastructure.DateUtils;
import com.andaily.hb.infrastructure.jpa.ApplicationInstanceRepositoryJpa;
import com.andaily.hb.infrastructure.jpa.FrequencyMonitorLogRepository;
import com.andaily.hb.infrastructure.jpa.NetworkInstanceRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

/**
 * @author Shengzhao Li
 */
@Component
public class MonitoringInstanceDtoLoader {

    @Autowired
    private ApplicationInstanceRepositoryJpa instanceRepository;

    /**
     * @since 3.0.0
     */
    @Autowired
    private NetworkInstanceRepository networkInstanceRepository;

    @Autowired
    private FrequencyMonitorLogRepository logRepository;


    public MonitoringInstanceDtoLoader() {
    }

    public MonitoringInstanceDto load(String guid) {
        MonitoringInstanceDto instanceDto;
        final ApplicationInstance instance = instanceRepository.findByGuid(guid);
        if (instance != null) {
            instanceDto = new MonitoringInstanceDto(instance);
            loadChartData(instance, instanceDto);
        } else {
            //网络实例  v3.0.0
            NetworkInstance networkInstance = networkInstanceRepository.findByGuid(guid);
            instanceDto = new MonitoringInstanceDto(networkInstance);
            loadChartData(networkInstance, instanceDto);
        }

        return instanceDto;
    }

    private void loadChartData(ApplicationInstance instance, MonitoringInstanceDto instanceDto) {
        //default 20 result
        List<FrequencyMonitorLog> monitorLogs = logRepository.findLatestFrequencyMonitorLogs(instance, PageRequest.ofSize(20));

        generateChartData(instanceDto, monitorLogs);
    }

    /**
     * @since 3.0.0
     */
    private void loadChartData(NetworkInstance instance, MonitoringInstanceDto instanceDto) {
        //default 20 result
        List<FrequencyMonitorLog> monitorLogs = logRepository.findLatestFrequencyMonitorLogs(instance, PageRequest.ofSize(20));

        generateChartData(instanceDto, monitorLogs);
    }

    private void generateChartData(MonitoringInstanceDto instanceDto, List<FrequencyMonitorLog> monitorLogs) {
        MonitoringChartDataGenerator chartDataGenerator = new MonitoringChartDataGenerator(monitorLogs);
        instanceDto.setCategoryData(chartDataGenerator.generateCategoryData());
        instanceDto.setSeriesData(chartDataGenerator.generateSeriesData());
        lastLogDate(instanceDto, monitorLogs);
    }


    private void lastLogDate(MonitoringInstanceDto indexInstanceDto, List<FrequencyMonitorLog> monitorLogs) {
        final Date time = monitorLogs.isEmpty() ? DateUtils.now() : monitorLogs.get(0).createTime();
        indexInstanceDto.setLastLogDate(DateUtils.toDateText(time, DateUtils.DEFAULT_DATE_TIME_FORMAT));
    }
}