package com.andaily.hb.service.operation;

import com.andaily.hb.domain.dto.IndexAdditionInstanceDto;
import com.andaily.hb.domain.log.FrequencyMonitorLog;
import com.andaily.hb.infrastructure.DateUtils;
import com.andaily.hb.infrastructure.ThreadLocalHolder;
import com.andaily.hb.infrastructure.jpa.FrequencyMonitorLogRepository;
import com.andaily.hb.infrastructure.jpa.NetworkInstanceRepository;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * @author Shengzhao Li
 */
@Component
public class IndexAdditionInstanceDtoLoader {

    private static final org.slf4j.Logger LOG = org.slf4j.LoggerFactory.getLogger(IndexAdditionInstanceDtoLoader.class);

    @Autowired
    private FrequencyMonitorLogRepository logRepository;

    @Autowired
    private NetworkInstanceRepository networkInstanceRepository;


    public IndexAdditionInstanceDtoLoader() {
    }

    public IndexAdditionInstanceDto load(IndexAdditionInstanceDto dto) {
        String instanceGuid = dto.getGuid();
        boolean networkInstance = networkInstanceRepository.countByGuid(instanceGuid) > 0;

        String lastLogDate = dto.getLastLogDate();
        List<FrequencyMonitorLog> monitorLogs;
        if (StringUtils.isBlank(lastLogDate)) {
            LOG.warn("{}|Invalid param 'minCreateTime' null or empty, instanceGuid: {}", ThreadLocalHolder.clientIp(), instanceGuid);
            monitorLogs = Collections.emptyList();
        } else {
            Date minCreateTime = DateUtils.getDate(lastLogDate, DateUtils.DEFAULT_DATE_TIME_FORMAT);
            monitorLogs = networkInstance ?
                    logRepository.findNetworkFrequencyMonitorLogs(instanceGuid, minCreateTime) :
                    logRepository.findFrequencyMonitorLogs(instanceGuid, minCreateTime);
        }

        MonitoringChartDataGenerator chartDataGenerator = new MonitoringChartDataGenerator(monitorLogs);
        dto.setAdditionData(chartDataGenerator.generateAdditionData());

        updateLastLogDate(monitorLogs, dto);
        return dto;
    }

    private void updateLastLogDate(List<FrequencyMonitorLog> monitorLogs, IndexAdditionInstanceDto dto) {
        if (monitorLogs.isEmpty()) {
            return;
        }
        final Date time = monitorLogs.get(0).createTime();
        dto.setLastLogDate(DateUtils.toDateText(time, DateUtils.DEFAULT_DATE_TIME_FORMAT));
    }
}