package com.andaily.hb.service.impl;

import com.andaily.hb.domain.dto.log.FrequencyMonitorLogListDto;
import com.andaily.hb.domain.dto.log.ReminderLogListDto;
import com.andaily.hb.service.LogService;
import com.andaily.hb.service.operation.FrequencyMonitorLogListDtoLoader;
import com.andaily.hb.service.operation.ReminderLogListDtoLoader;
import com.andaily.hb.service.operation.job.AutoMonitorLogCleaner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 15-2-13
 *
 * @author Shengzhao Li
 */
@Service("logService")
public class LogServiceImpl implements LogService {


    @Autowired
    private FrequencyMonitorLogListDtoLoader frequencyMonitorLogListDtoLoader;

    @Autowired
    private ReminderLogListDtoLoader reminderLogListDtoLoader;

    @Transactional(readOnly = true)
    @Override
    public FrequencyMonitorLogListDto loadFrequencyMonitorLogListDto(FrequencyMonitorLogListDto listDto) {
        return frequencyMonitorLogListDtoLoader.load(listDto);
    }

    @Transactional(readOnly = true)
    @Override
    public ReminderLogListDto loadReminderLogListDto(ReminderLogListDto listDto) {
        return reminderLogListDtoLoader.load(listDto);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public long executeAutoCleanMonitorLogs() {
        AutoMonitorLogCleaner autoMonitorLogCleaner = new AutoMonitorLogCleaner();
        return autoMonitorLogCleaner.clean();
    }
}
