package com.andaily.hb.service.impl;

import com.andaily.hb.domain.dto.HBSearchDto;
import com.andaily.hb.domain.dto.IndexAdditionInstanceDto;
import com.andaily.hb.domain.dto.IndexDto;
import com.andaily.hb.domain.dto.MonitoringInstanceDto;
import com.andaily.hb.domain.shared.Application;
import com.andaily.hb.service.IndexService;
import com.andaily.hb.service.operation.search.HBSearchDtoLoader;
import com.andaily.hb.service.operation.IndexAdditionInstanceDtoLoader;
import com.andaily.hb.service.operation.IndexDtoLoader;
import com.andaily.hb.service.operation.MonitoringInstanceDtoLoader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author Shengzhao Li
 */
@Service("indexService")
@Transactional(readOnly = true)
public class IndexServiceImpl implements IndexService {


    @Autowired
    private MonitoringInstanceDtoLoader monitoringInstanceDtoLoader;


    @Autowired
    private IndexAdditionInstanceDtoLoader additionInstanceDtoLoader;

    @Autowired
    private IndexDtoLoader indexDtoLoader;


    @Override
    public IndexDto loadIndexDto(IndexDto indexDto) {
        return indexDtoLoader.load(indexDto);
    }

    @Override
    public IndexAdditionInstanceDto loadIndexAdditionInstanceDto(IndexAdditionInstanceDto additionInstanceDto) {
        return additionInstanceDtoLoader.load(additionInstanceDto);
    }

    @Override
    public MonitoringInstanceDto loadMonitoringInstanceDto(String guid) {
        return this.monitoringInstanceDtoLoader.load(guid);
    }

    @Override
    public HBSearchDto loadHBSearchDto(HBSearchDto searchDto) {
        HBSearchDtoLoader dtoLoader = new HBSearchDtoLoader(searchDto);
        return dtoLoader.load();
    }

    @Override
    public boolean loadAllowUserRegister() {
        return Application.systemSetting().allowUserRegister();
    }
}