package com.andaily.hb.service.impl;

import com.andaily.hb.domain.dto.notify.DingtalkRobotConfigFormDto;
import com.andaily.hb.domain.notify.DingtalkRobotConfig;
import com.andaily.hb.domain.shared.security.SecurityUtils;
import com.andaily.hb.infrastructure.jpa.DingtalkRobotConfigRepository;
import com.andaily.hb.service.DingtalkRobotConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 2024/1/9 10:22
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
@Service
public class DingtalkRobotConfigServiceImpl implements DingtalkRobotConfigService {
    private static final Logger LOG = LoggerFactory.getLogger(DingtalkRobotConfigServiceImpl.class);


    @Autowired
    private DingtalkRobotConfigRepository configRepository;


    /**
     * {@inheritDoc}
     */
    @Override
    public DingtalkRobotConfigFormDto loadDingtalkRobotConfigForm() {
        DingtalkRobotConfig config = configRepository.findDingtalkRobotConfig();
        if (config == null) {
            DingtalkRobotConfigFormDto formDto = new DingtalkRobotConfigFormDto();
            formDto.setNotifyContent(
                    "HB提醒通知：实例($instanceName$) 心跳监控状态【$status$】。\n监控时间：$time$\n监控URI：$monitorUri$\n连接耗时：$costTime$ ms\n详情链接：$link$");
            return formDto;
        } else {
            return new DingtalkRobotConfigFormDto(config);
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void saveDingtalkRobotConfig(DingtalkRobotConfigFormDto formDto) {
        DingtalkRobotConfig config = configRepository.findDingtalkRobotConfig();
        if (config == null) {
            config = new DingtalkRobotConfig();
        }

        config.robotWebhook(formDto.getRobotWebhook())
                .enabled(formDto.isEnabled())
                .notifyContent(formDto.getNotifyContent())
                .phones(formDto.getPhones())
                .atAll(formDto.isAtAll());

        configRepository.save(config);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<{}> Save DingtalkRobotConfig [{}]", SecurityUtils.currentUsername(), config);
        }
    }
}
