package com.andaily.hb.service;

import com.andaily.hb.domain.dto.network.NetworkInstanceFormDto;
import com.andaily.hb.domain.dto.network.NetworkInstanceListDto;

/**
 * 2023/12/13 20:25
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
public interface NetworkInstanceService {

    /**
     * Load network instance list dto
     */
    NetworkInstanceListDto loadNetworkInstanceListDto(NetworkInstanceListDto listDto);

    /**
     * Enable network instance
     */
    boolean enableNetworkInstance(String guid);

    /**
     * Stop monitoring network instance
     */
    boolean stopMonitoringNetworkInstance(String guid);

    /**
     * Delete network instance
     */
    boolean deleteNetworkInstance(String guid);

    /**
     * Load network instance form dto
     */
    NetworkInstanceFormDto loadNetworkInstanceFormDto(String guid);

    /**
     * Persist network instance
     */
    void persistNetworkInstance(NetworkInstanceFormDto formDto);
}
