package com.andaily.hb.infrastructure.jpa;

import com.andaily.hb.domain.user.User;
import com.andaily.hb.domain.user.UserPrivilege;
import com.andaily.hb.domain.user.WeixinUser;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * 2023/11/20 14:41
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
public interface UserRepositoryJpa extends JpaRepository<User, Integer>, JpaSpecificationExecutor<User> {


    /**
     * 根据 guid 查询
     */
    User findByGuid(String guid);

    /**
     * 查找用户
     */
    @Query("select u from User u where u.username = :username and u.archived = false")
    User findByUsername(String username);

    /**
     * 查询用户的权限
     */
    @Query(" select up from UserPrivilege up where up.archived = false and up.user = :user")
    List<UserPrivilege> findUserPrivileges(User user);

    /**
     * 查询用户，不管是否逻辑删除
     */
    @Query("select u from User u where u.username = :username ")
    User findByUsernameIgnoreArchived(String username);

    /**
     * 查找微信用户
     */
    @Query("select wu from WeixinUser wu where wu.archived = false and wu.hbUsername = :username ")
    List<WeixinUser> findWeixinUsersByUsername(String username);


    /**
     * 查找微信用户 guid list
     */
    @Query("select aiw.weixinUser.guid from ApplicationInstanceWeixinUser aiw where aiw.archived = false and aiw.applicationInstance.guid = :instanceGuid")
    List<String> findWeixinUserGuids(String instanceGuid);

    /**
     * 查找微信用户
     *
     * @param guid guid
     * @return WeixinUser or null
     */
    @Query("select wu from WeixinUser wu where wu.archived = false and wu.guid = :guid ")
    WeixinUser findWeixinUserByGuid(String guid);

    /**
     * 查找微信用户, 根据instanceGuid
     */
    @Query("select aiw.weixinUser from ApplicationInstanceWeixinUser aiw where aiw.archived = false and aiw.applicationInstance.guid = :instanceGuid")
    List<WeixinUser> findWeixinUsersByInstanceGuid(String instanceGuid);

}
