package com.andaily.hb.infrastructure.jpa;

import com.andaily.hb.domain.user.SystemSetting;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

/**
 * 2023/11/20 15:27
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
public interface SystemSettingRepository extends JpaRepository<SystemSetting, Integer> {

    /**
     * Just one instance
     * //If not found,will return default
     */
    @Query("select ss from SystemSetting ss where ss.archived = false ")
    SystemSetting findSystemSetting();

    /**
     * 根据guid 查询
     */
    SystemSetting findByGuid(String guid);

}
