package com.andaily.hb.infrastructure.jpa;

import com.andaily.hb.domain.network.NetworkInstance;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * 2023/12/13 10:59
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
public interface NetworkInstanceRepository extends JpaRepository<NetworkInstance, Integer>, JpaSpecificationExecutor<NetworkInstance> {

    /**
     * Find network instance by guid
     *
     * @param guid guid
     * @return network instance
     */
    @Query("select ni from NetworkInstance ni where ni.guid =:guid ")
    NetworkInstance findByGuid(String guid);

    /**
     * 统计guid下所有网络实例的数量
     *
     * @param guid guid
     * @return count
     */
    @Query("select count(ni.id) from NetworkInstance ni where ni.guid =:guid ")
    int countByGuid(String guid);

    /**
     * 查询所有有日志的公开实例
     */
    @Query("select a from NetworkInstance a where a.archived = false  and a.privateInstance = false and " +
            " exists ( select ml from FrequencyMonitorLog ml where ml.archived = false and ml.networkInstance.id = a.id )  order by a.createTime desc ")
    List<NetworkInstance> findHadLogPublicInstances();

    /**
     * 查询所有有日志的实例
     */
    @Query("select a from NetworkInstance a where a.archived = false and " +
            " exists ( select ml from FrequencyMonitorLog ml where ml.archived = false and ml.networkInstance.id = a.id )  order by a.createTime desc ")
    List<NetworkInstance> findHadLogInstances();

    /**
     * 查询所有有日志的公开实例
     *
     * @since 3.00
     */
    @Query("select a from NetworkInstance a where a.archived = false and a.privateInstance = false and a.enabled = :enabled " +
            " and exists ( select ml from FrequencyMonitorLog ml where ml.archived = false and ml.networkInstance.id = a.id )  order by a.createTime desc ")
    List<NetworkInstance> findHadLogPublicInstancesByEnabled(boolean enabled);

    /**
     * 查询所有有日志的实例
     *
     * @param enabled true 启用 false 禁用
     */
    @Query("select a from NetworkInstance a where a.archived = false and a.enabled = :enabled " +
            " and exists ( select ml from FrequencyMonitorLog ml where ml.archived = false and ml.networkInstance.id = a.id )  order by a.createTime desc ")
    List<NetworkInstance> findHadLogInstancesByEnabled(boolean enabled);
}
