package com.andaily.hb.infrastructure.jpa;

import com.andaily.hb.domain.log.MonitoringReminderLog;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import java.util.Date;

/**
 * 2023/11/21 22:50
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
public interface MonitoringReminderLogRepository extends JpaRepository<MonitoringReminderLog, Integer>, JpaSpecificationExecutor<MonitoringReminderLog> {

    /**
     * Find by guid
     *
     * @param guid guid
     * @return MonitoringReminderLog
     */
    MonitoringReminderLog findByGuid(String guid);

    /**
     * Total monitoring reminder logs
     *
     * @param instanceGuid instance guid
     * @return int
     */
    @Query(" select count(ml.guid) from  MonitoringReminderLog ml where ml.archived = false and ml.instance.guid = :instanceGuid ")
    int totalMonitoringReminderLogs(String instanceGuid);

    /**
     * Total monitoring reminder logs (network)
     *
     * @param instanceGuid instance guid
     * @return int
     */
    @Query(" select count(ml.guid) from  MonitoringReminderLog ml where ml.archived = false and ml.networkInstance.guid = :instanceGuid ")
    int totalNetworkMonitoringReminderLogs(String instanceGuid);

    /**
     * Amount of monitoring reminder logs
     *
     * @param instanceGuid instance guid
     * @param changeNormal change normal
     * @return int
     */
    @Query(" select count(ml.guid) from  MonitoringReminderLog ml where ml.archived = false and ml.instance.guid = :instanceGuid and ml.changeNormal = :changeNormal ")
    int amountOfMonitoringReminderLogs(String instanceGuid, boolean changeNormal);

    /**
     * Amount of monitoring reminder logs (network)
     *
     * @param instanceGuid instance guid
     * @param changeNormal change normal
     * @return int
     */
    @Query(" select count(ml.guid) from  MonitoringReminderLog ml where ml.archived = false and ml.networkInstance.guid = :instanceGuid and ml.changeNormal = :changeNormal ")
    int amountOfNetworkMonitoringReminderLogs(String instanceGuid, boolean changeNormal);

    /**
     * Amount of monitoring reminder logs before date
     *
     * @param date date
     * @return long
     */
    @Query(" select count(ml.guid) from MonitoringReminderLog ml where ml.archived = false and unix_timestamp(ml.createTime) < :date ")
    long amountOfMonitoringReminderLogsBeforeDate(long date);

    /**
     * Delete monitoring reminder logs before date
     *
     * @param date date
     * @return int
     */
    @Modifying
    @Query(" delete from MonitoringReminderLog ml where ml.archived = false and ml.createTime < :date ")
    int deleteMonitoringReminderLogsBeforeDate(Date date);

    /**
     * Delete network instance logs
     *
     * @param instanceGuid instance guid
     * @return row
     */
    @Modifying
    @Query("delete from MonitoringReminderLog ml where ml.instance.guid = :instanceGuid")
    int deleteNetworkInstanceLogs(String instanceGuid);
}
