package com.andaily.hb.infrastructure.jpa;

import com.andaily.hb.domain.application.ApplicationInstance;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 2023/11/20 16:58
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
public interface ApplicationInstanceRepositoryJpa extends JpaRepository<ApplicationInstance, Integer>, JpaSpecificationExecutor<ApplicationInstance> {


    /**
     * 根据 guid 查询
     */
    @Query("select ai from ApplicationInstance ai where ai.guid = :guid ")
    ApplicationInstance findByGuid(String guid);

    /**
     * 查询所有启用的实例
     */
    @Query(" from ApplicationInstance ai where ai.archived = false and ai.enabled = true")
    List<ApplicationInstance> findAllEnabledInstances();

    /**
     * 删除实例的监控日志
     *
     * @param instanceGuid instanceGuid
     * @return row
     */
    @Modifying
    @Transactional(rollbackFor = Exception.class)
    @Query("delete from FrequencyMonitorLog ml where ml.instance.guid = :instanceGuid")
    int deleteInstanceFrequencyMonitorLogs(String instanceGuid);

    /**
     * 删除实例的监控提醒日志
     */
    @Modifying
    @Transactional(rollbackFor = Exception.class)
    @Query("delete from MonitoringReminderLog ml where ml.instance.guid = :instanceGuid")
    int deleteInstanceMonitoringReminderLogs(String instanceGuid);

    /**
     * 删除实例的微信用户
     */
    @Modifying
    @Transactional(rollbackFor = Exception.class)
    @Query("delete from ApplicationInstanceWeixinUser wu where wu.applicationInstance = :instance")
    int deleteApplicationInstanceWeixinUsers(ApplicationInstance instance);

    /**
     * 查询所有有日志的实例
     */
    @Query("select a from ApplicationInstance a where a.archived = false and " +
            " exists ( select ml from FrequencyMonitorLog ml where ml.archived = false and ml.instance.id = a.id )  order by a.createTime desc ")
    List<ApplicationInstance> findHadLogInstances();

    /**
     * 查询所有有日志的公开实例
     */
    @Query("select a from ApplicationInstance a where a.archived = false  and a.privateInstance = false and " +
            " exists ( select ml from FrequencyMonitorLog ml where ml.archived = false and ml.instance.id = a.id )  order by a.createTime desc ")
    List<ApplicationInstance> findHadLogPublicInstances();

    /**
     * 查询所有有日志的公开实例
     *
     * @param enabled true 启用 false 禁用
     */
    @Query("select a from ApplicationInstance a where a.archived = false and a.privateInstance = false and a.enabled = :enabled " +
            " and exists ( select ml from FrequencyMonitorLog ml where ml.archived = false and ml.instance.id = a.id )  order by a.createTime desc ")
    List<ApplicationInstance> findHadLogPublicInstancesByEnabled(boolean enabled);

    /**
     * 查询所有有日志的实例
     *
     * @param enabled true 启用 false 禁用
     */
    @Query("select a from ApplicationInstance a where a.archived = false and a.enabled = :enabled " +
            " and exists ( select ml from FrequencyMonitorLog ml where ml.archived = false and ml.instance.id = a.id )  order by a.createTime desc ")
    List<ApplicationInstance> findHadLogInstancesByEnabled(boolean enabled);

    /**
     * 查询所有有提醒日志的公开实例
     */
    @Query("select a from ApplicationInstance a where a.archived = false and a.privateInstance = false and " +
            " exists ( select ml from MonitoringReminderLog ml where ml.archived = false and ml.instance.id = a.id )  order by a.createTime desc ")
    List<ApplicationInstance> findDistinctReminderLogPublicInstances();

    /**
     * 查询所有有提醒日志的实例
     */
    @Query("select a from ApplicationInstance a where a.archived = false " +
            " and exists ( select ml from MonitoringReminderLog ml where ml.archived = false and ml.instance.id = a.id )  order by a.createTime desc ")
    List<ApplicationInstance> findDistinctReminderLogInstances();
}
