package com.andaily.hb.infrastructure.hibernate;

import com.andaily.hb.domain.user.*;
import com.andaily.hb.infrastructure.hibernate.queryhelper.impl.ListUsersQueryHelper;
import com.andaily.hb.infrastructure.hibernate.queryhelper.impl.WeixinUsersQueryHelper;
import com.google.common.collect.ImmutableMap;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * @author Shengzhao Li
 * @deprecated use UserRepositoryJpa replaced from v3.0.0
 */
@Deprecated
@Repository("userRepository")
public class UserRepositoryHibernate extends AbstractRepositoryHibernate<User> implements UserRepository {

    @Override
    public User findByUsername(String username) {
        final List<User> list = find("from User u where u.username = :username and u.archived = false", ImmutableMap.of("username", username));
        return list.isEmpty() ? null : list.get(0);
    }

    @Override
    @SuppressWarnings("unchecked")
    public List<Privilege> findUserPrivileges(User user) {
        final String hql = " select up.privilege from UserPrivilege up where up.archived = false and up.user = :user";
        final Query query = session().createQuery(hql)
                .setParameter("user", user);
        return query.getResultList();
    }

    @Override
    public List<User> findListUsers(Map<String, Object> map) {
        ListUsersQueryHelper queryHelper = new ListUsersQueryHelper(session(), map);
        return queryHelper.getResults();
    }

    @Override
    public int totalListUsers(Map<String, Object> map) {
        ListUsersQueryHelper queryHelper = new ListUsersQueryHelper(session(), map);
        return queryHelper.getAmount();
    }

    @Override
    public User findByUsernameIgnoreArchived(String username) {
        final List<User> list = find("from User u where u.username = :username ", ImmutableMap.of("username", username));
        return list.isEmpty() ? null : list.get(0);
    }

    @Override
    public int deleteUserPrivileges(User user) {
        String hql = "delete from UserPrivilege up where up.user = :user ";
        try (EntityManager session = session()) {
            session.getTransaction().begin();
            int row = session.createQuery(hql).setParameter("user", user).executeUpdate();
            session.getTransaction().commit();
            return row;
        }
//        final List<UserPrivilege> privileges = find(hql, ImmutableMap.of("user", user));
//        deleteAll(privileges);
//        return privileges.size();
    }

    @Override
    public List<WeixinUser> findWeixinUsersByUsername(String username) {
        return find(" from WeixinUser wu where wu.archived = false and wu.hbUsername = :username ", ImmutableMap.of("username", username));
    }

    @Override
    public SystemSetting findSystemSetting() {
        String hql = "select ss from SystemSetting ss where ss.archived = false ";
        SystemSetting systemSetting = (SystemSetting) session().createQuery(hql).getSingleResult();
        if (systemSetting == null) {
            systemSetting = new SystemSetting();
        }
        return systemSetting;
    }

    @Override
    @SuppressWarnings("unchecked")
    public List<String> findWeixinUserGuids(String instanceGuid) {
        String hql = " select aiw.weixinUser.guid from ApplicationInstanceWeixinUser aiw where aiw.archived = false and aiw.applicationInstance.guid = :instanceGuid";
        return session().createQuery(hql).setParameter("instanceGuid", instanceGuid).getResultList();
    }

    @Override
    public WeixinUser findWeixinUserByGuid(String guid) {
        return findByGuid(guid, WeixinUser.class);
    }

    @Override
    public List<WeixinUser> findWeixinUsersByInstanceGuid(String instanceGuid) {
        String hql = " select aiw.weixinUser from ApplicationInstanceWeixinUser aiw where aiw.archived = false and aiw.applicationInstance.guid = :instanceGuid";
        return find(hql, ImmutableMap.of("instanceGuid", instanceGuid));
    }

    @Override
    public List<WeixinUser> findWeixinUserList(Map<String, Object> map) {
        WeixinUsersQueryHelper queryHelper = new WeixinUsersQueryHelper(session(), map);
        return queryHelper.getResults();
    }

    @Override
    public int totalWeixinUserList(Map<String, Object> map) {
        WeixinUsersQueryHelper queryHelper = new WeixinUsersQueryHelper(session(), map);
        return queryHelper.getAmount();
    }
}