package com.andaily.hb.infrastructure.hibernate;

import com.andaily.hb.domain.application.ApplicationInstance;
import com.andaily.hb.domain.log.FrequencyMonitorLog;
import com.andaily.hb.domain.log.LogRepository;
import com.andaily.hb.domain.log.MonitoringReminderLog;
import com.andaily.hb.domain.shared.security.SecurityUtils;
import com.andaily.hb.infrastructure.DateUtils;
import com.andaily.hb.infrastructure.ThreadLocalHolder;
import com.andaily.hb.infrastructure.hibernate.queryhelper.impl.FrequencyMonitorLogListQueryHelper;
import com.andaily.hb.infrastructure.hibernate.queryhelper.impl.HBSearchMonitorLogsQueryHelper;
import com.andaily.hb.infrastructure.hibernate.queryhelper.impl.ReminderLogListQueryHelper;
import com.google.common.collect.ImmutableMap;
import jakarta.persistence.Query;
import org.apache.commons.lang.StringUtils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author Shengzhao Li
 * @deprecated use FrequencyMonitorLogRepository, MonitoringReminderLogRepository replaced from v3.0.0
 */
@Deprecated
@Repository("logRepository")
public class LogRepositoryHibernate extends AbstractRepositoryHibernate<FrequencyMonitorLog> implements LogRepository {

    private static final Logger LOG = LoggerFactory.getLogger(LogRepositoryHibernate.class);


    @Override
    public List<FrequencyMonitorLog> findFrequencyMonitorLogList(Map<String, Object> map) {
        FrequencyMonitorLogListQueryHelper queryHelper = new FrequencyMonitorLogListQueryHelper(entityManager(), map);
        return queryHelper.getResults();
    }

    @Override
    public int totalFrequencyMonitorLogList(Map<String, Object> map) {
        FrequencyMonitorLogListQueryHelper queryHelper = new FrequencyMonitorLogListQueryHelper(entityManager(), map);
        return queryHelper.getAmount();
    }

    @Override
    public List<ApplicationInstance> findHadLogInstances() {
//        String hql = "select distinct ml.instance from FrequencyMonitorLog ml where ml.archived = 0 and ml.instance.archived = false ";
        StringBuilder hql = new StringBuilder(" from ApplicationInstance a where a.archived = false and ");
        hql.append(" exists ( from FrequencyMonitorLog ml where ml.archived = false and ml.instance.id = a.id ) ");
        if (SecurityUtils.currentUser() == null) {
            hql.append(" and a.privateInstance = false ");
        }
        hql.append(" order by a.createTime desc ");
        return find(hql.toString());
    }

    @Override
    @SuppressWarnings("unchecked")
    public List<FrequencyMonitorLog> findLatestFrequencyMonitorLogs(ApplicationInstance instance, int maxResult) {
        String hql = "select ml from FrequencyMonitorLog ml where ml.archived = false and ml.instance = :instance order by ml.createTime desc";
        final Query query = session().createQuery(hql)
                .setParameter("instance", instance)
                .setMaxResults(maxResult);
        return query.getResultList();
    }

    @Override
    public List<FrequencyMonitorLog> findFrequencyMonitorLogs(String instanceGuid, String minCreateTime) {
        if (StringUtils.isBlank(minCreateTime)) {
            LOG.warn("{}|Invalid param 'minCreateTime' null or empty, instanceGuid: {}", ThreadLocalHolder.clientIp(), instanceGuid);
            return Collections.emptyList();
        }
        String hql = " from FrequencyMonitorLog ml where ml.archived = false and ml.instance.guid = :instanceGuid and ml.createTime > :minCreateTime order by ml.createTime desc";
        return find(hql, ImmutableMap.of("instanceGuid", instanceGuid, "minCreateTime", DateUtils.getDate(minCreateTime, DateUtils.DEFAULT_DATE_TIME_FORMAT)));
    }

    @Override
    public List<ApplicationInstance> findHadLogInstancesByEnabled(boolean enabled) {
//        String hql = "select distinct ml.instance from FrequencyMonitorLog ml where ml.archived = 0 and ml.instance.enabled = :enabled " +
//                "  and ml.instance.archived = false ";
        StringBuilder hql = new StringBuilder(" from ApplicationInstance a where a.archived = false and a.enabled = :enabled and ");
        hql.append(" exists ( from FrequencyMonitorLog ml where ml.archived = false and ml.instance.id = a.id ) ");
        if (SecurityUtils.currentUser() == null) {
            hql.append(" and a.privateInstance = false ");
        }
        hql.append(" order by a.createTime desc ");
        return find(hql.toString(), ImmutableMap.of("enabled", enabled));
    }

    @Override
    public FrequencyMonitorLog findLastLogByCurrentLog(FrequencyMonitorLog currentLog) {
        String hql = "select ml from FrequencyMonitorLog ml where ml.archived = false and ml.instance = :instance and ml.createTime < :createTime order by ml.createTime desc ";
        final Query query = session().createQuery(hql)
                .setParameter("instance", currentLog.instance())
                .setParameter("createTime", currentLog.createTime())
                .setMaxResults(1);
        return (FrequencyMonitorLog) query.getSingleResult();
    }

    @Override
    public FrequencyMonitorLog findLastNotNormalFrequencyMonitorLog(String instanceGuid) {
        String hql = " select ml from FrequencyMonitorLog ml where ml.archived = false and ml.instance.guid = :instanceGuid and ml.normal = :normal " +
                " and ml.createTime < :createTime order by ml.createTime desc  ";
        final Query query = session().createQuery(hql)
                .setParameter("instanceGuid", instanceGuid)
                .setParameter("createTime", DateUtils.now())
                .setParameter("normal", false)
                .setMaxResults(1);
        return (FrequencyMonitorLog) query.getSingleResult();
    }

    @Override
    public int amountOfInstanceMonitorLogs(String instanceGuid, boolean normal) {
        String hql = " select count(ml.guid) from FrequencyMonitorLog ml where ml.archived = false and ml.instance.guid = :instanceGuid and ml.normal = :normal ";
        final Query query = session().createQuery(hql)
                .setParameter("instanceGuid", instanceGuid)
                .setParameter("normal", normal)
                .setMaxResults(1);

        return ((Long) query.getSingleResult()).intValue();
    }

    @Override
    public int totalMonitoringReminderLogs(String instanceGuid) {
        String hql = " select count(ml.guid) from  MonitoringReminderLog ml where ml.archived = false and ml.instance.guid = :instanceGuid ";
        final Query query = session().createQuery(hql)
                .setParameter("instanceGuid", instanceGuid)
                .setMaxResults(1);

        return ((Long) query.getSingleResult()).intValue();
    }

    @Override
    public int amountOfMonitoringReminderLogs(String instanceGuid, boolean changeNormal) {
        String hql = " select count(ml.guid) from  MonitoringReminderLog ml where ml.archived = false and ml.instance.guid = :instanceGuid and ml.changeNormal = :changeNormal ";
        final Query query = session().createQuery(hql)
                .setParameter("instanceGuid", instanceGuid)
                .setParameter("changeNormal", changeNormal)
                .setMaxResults(1);

        return ((Long) query.getSingleResult()).intValue();
    }

    @Override
    public Date findFirstMonitoringLogTime(String instanceGuid, boolean normal) {
        String hql = " select ml.createTime from  FrequencyMonitorLog ml where ml.archived = false " +
                " and ml.instance.guid = :instanceGuid and ml.normal = :normal order by ml.createTime asc ";
        final Query query = session().createQuery(hql)
                .setParameter("instanceGuid", instanceGuid)
                .setParameter("normal", normal)
                .setMaxResults(1);

        return (Date) query.getSingleResult();
    }

    @Override
    public Date findFirstMonitoringLogTimeAfterSpecifyTime(String instanceGuid, Date specifyTime) {
        String hql = " select ml.createTime from  FrequencyMonitorLog ml where ml.archived = false " +
                " and ml.instance.guid = :instanceGuid and ml.createTime > :time order by ml.createTime asc ";
        final Query query = session().createQuery(hql)
                .setParameter("instanceGuid", instanceGuid)
                .setParameter("time", specifyTime)
                .setMaxResults(1);

        return (Date) query.getSingleResult();
    }

    @Override
    public List<FrequencyMonitorLog> findHBSearchMonitorLogs(Map<String, Object> map) {
        HBSearchMonitorLogsQueryHelper queryHelper = new HBSearchMonitorLogsQueryHelper(session(), map);
        return queryHelper.getResults();
    }

    @Override
    public int totalHBSearchMonitorLogs(Map<String, Object> map) {
        HBSearchMonitorLogsQueryHelper queryHelper = new HBSearchMonitorLogsQueryHelper(session(), map);
        return queryHelper.getAmount();
    }

    @Override
    public List<MonitoringReminderLog> findMonitoringReminderLogList(Map<String, Object> map) {
        ReminderLogListQueryHelper queryHelper = new ReminderLogListQueryHelper(session(), map);
        return queryHelper.getResults();
    }

    @Override
    public int totalMonitoringReminderLogList(Map<String, Object> map) {
        ReminderLogListQueryHelper queryHelper = new ReminderLogListQueryHelper(session(), map);
        return queryHelper.getAmount();
    }

    @Override
    public List<ApplicationInstance> findDistinctReminderLogInstances() {
//        String hql = " select distinct rl.instance from MonitoringReminderLog rl where rl.archived = false ";
        StringBuilder hql = new StringBuilder(" from ApplicationInstance a where a.archived = false and ");
        hql.append(" exists ( from MonitoringReminderLog ml where ml.archived = false and ml.instance.id = a.id ) ");
        if (SecurityUtils.currentUser() == null) {
            hql.append(" and a.privateInstance = false ");
        }
        hql.append(" order by a.createTime desc ");
        return find(hql.toString());
    }

    @Override
    @SuppressWarnings("unchecked")
    public List<FrequencyMonitorLog> findLastLogsByCurrentLog(FrequencyMonitorLog currentLog, int max) {
        String hql = "select ml from FrequencyMonitorLog ml where ml.archived = false and ml.instance = :instance " +
                " and ml.createTime < :createTime and ml.id < :currId order by ml.createTime desc ";
        final Query query = session().createQuery(hql)
                .setParameter("instance", currentLog.instance())
                .setParameter("currId", currentLog.id())
                .setParameter("createTime", currentLog.createTime())
                .setMaxResults(max);
        return query.getResultList();
    }

    @Override
    public long amountOfMonitoringReminderLogsBeforeDate(Date date) {
        String hql = " select count(ml.guid) from MonitoringReminderLog ml where ml.archived = false and unix_timestamp(ml.createTime) < :date ";
        final Query query = session().createQuery(hql)
                .setParameter("date", date.getTime());
        return (long) query.getSingleResult();
    }

    /**
     * 批量操作, 去数据库删除
     */
    @Override
    public int deleteMonitoringReminderLogsBeforeDate(Date date) {
        String hql = " delete from MonitoringReminderLog ml where ml.archived = false and ml.createTime < :date ";
        final Query query = session().createQuery(hql)
                .setParameter("date", date);
        return query.executeUpdate();
    }

    @Override
    public long amountOfFrequencyMonitorLogsBeforeDate(Date date) {
        String hql = " select count(ml.guid) from FrequencyMonitorLog ml where ml.archived = false and ml.createTime < :date ";
        final Query query = session().createQuery(hql)
                .setParameter("date", date);
        return (long) query.getSingleResult();
    }

    @Override
    public int deleteFrequencyMonitorLogsBeforeDate(Date date) {
        String hql = " delete from FrequencyMonitorLog ml where ml.archived = false and ml.createTime < :date ";
        final Query query = session().createQuery(hql)
                .setParameter("date", date);
        return query.executeUpdate();
    }

}