package com.andaily.hb.infrastructure;

import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

import static com.andaily.hb.domain.shared.Application.ENCODING;

/**
 * 2023/12/4 10:26
 * <p>
 * AES 加密、解密工具类
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
public abstract class AesUtils {


    private static final String AES = "AES";
    private static final String PKCS = AES + "/ECB/PKCS5Padding";

    final static String DEFAULT_KEY = "ub8uO2nHIRkixWeGbUl1geJwnsWZS4kJ";


    private final static Cipher CIPHER;


    static {
        try {
            CIPHER = Cipher.getInstance(PKCS);
        } catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException("Initial Cipher error", e);
        }
    }


    private AesUtils() {
    }

    public static String encrypt(String originalText) {
        return encrypt(originalText, DEFAULT_KEY);
    }


    /**
     * 加密数据
     */
    public static String encrypt(String originalText, String key) {
        if (key == null) {
            key = DEFAULT_KEY;
        }
        try {
            byte[] raw = key.getBytes(ENCODING);
            SecretKeySpec skeySpec = getSecretKeySpec(raw);

            CIPHER.init(Cipher.ENCRYPT_MODE, skeySpec);
            byte[] encrypted = CIPHER.doFinal(originalText.getBytes(ENCODING));

            return Base64.getEncoder().encodeToString(encrypted);
        } catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static String decrypt(String encoded) {
        return decrypt(encoded, DEFAULT_KEY);
    }

    /**
     * 解密数据
     */
    public static String decrypt(String encoded, String key) {
        if (key == null) {
            key = DEFAULT_KEY;
        }
        try {
            byte[] raw = key.getBytes(ENCODING);
            SecretKeySpec skeySpec = getSecretKeySpec(raw);

            CIPHER.init(Cipher.DECRYPT_MODE, skeySpec);
            byte[] encrypted1 = Base64.getDecoder().decode(encoded);

            byte[] original = CIPHER.doFinal(encrypted1);
            return new String(original, ENCODING);

        } catch (Exception ex) {
            throw new IllegalStateException("Decrypt error", ex);
        }
    }


    private static SecretKeySpec getSecretKeySpec(byte[] raw) {
        return new SecretKeySpec(raw, AES);
    }


}
