package com.andaily.hb.domain.user;

import com.andaily.hb.domain.AbstractDomain;

import jakarta.persistence.*;

import java.io.Serial;

/**
 * @author Shengzhao Li
 */
@Entity
@Table(name = "user_privilege")
public class UserPrivilege extends AbstractDomain {

    @Serial
    private static final long serialVersionUID = -7207158121413995079L;
    @ManyToOne
    @JoinColumn(name = "user_id")
    private User user;

    @Column(name = "privilege")
    @Enumerated(value = EnumType.STRING)
    private Privilege privilege;

    public UserPrivilege() {
    }

    public UserPrivilege(User user, Privilege privilege) {
        this.user = user;
        this.privilege = privilege;
    }

    public Privilege privilege() {
        return privilege;
    }

    public User user() {
        return user;
    }
}