package com.andaily.hb.domain.notify;

import com.andaily.hb.domain.AbstractDomain;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;

import java.io.Serial;

/**
 * 2023/12/3 12:46
 * <p>
 * 邮件配置
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
@Entity
@Table(name = "email_config")
public class EmailConfig extends AbstractDomain {
    @Serial
    private static final long serialVersionUID = 3058936877185838014L;

    /**
     * SMTP host
     */
    @Column(name = "host_name")
    private String hostName;

    /**
     * SMTP port
     */
    @Column(name = "smtp_port")
    private int smtpPort;

    /**
     * 发送的邮件地址
     */
    @Column(name = "send_email")
    private String sendEmail;

    /**
     * 邮箱密码
     * 加密保存
     */
    @Column(name = "password")
    private String password;

    /**
     * true 使用SSL安全通道
     */
    @Column(name = "smtp_auth")
    private boolean smtpAuth = true;

    /**
     * 是否开启 默认开启
     */
    @Column(name = "enabled")
    private boolean enabled = true;


    /**
     * 是否启用开发环境
     */
    @Column(name = "develop_environment")
    private boolean developEnvironment;


    /**
     * 开发环境指定的邮箱地址
     */
    @Column(name = "develop_email")
    private String developEmail;


    /**
     * 是否使用新线程发送邮件
     * 默认不使用
     */
    @Column(name = "send_mail_use_thread")
    private boolean sendMailUseThread;


    public EmailConfig() {
    }

    public boolean developEnvironment() {
        return developEnvironment;
    }

    public EmailConfig developEnvironment(boolean developEnvironment) {
        this.developEnvironment = developEnvironment;
        return this;
    }

    public String developEmail() {
        return developEmail;
    }

    public EmailConfig developEmail(String developEmail) {
        this.developEmail = developEmail;
        return this;
    }

    public boolean sendMailUseThread() {
        return sendMailUseThread;
    }

    public EmailConfig sendMailUseThread(boolean sendMailUseThread) {
        this.sendMailUseThread = sendMailUseThread;
        return this;
    }

    public String hostName() {
        return hostName;
    }

    public EmailConfig hostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public int smtpPort() {
        return smtpPort;
    }

    public EmailConfig smtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
        return this;
    }

    public String sendEmail() {
        return sendEmail;
    }

    public EmailConfig sendEmail(String sendEmail) {
        this.sendEmail = sendEmail;
        return this;
    }

    public String password() {
        return password;
    }

    public EmailConfig password(String password) {
        this.password = password;
        return this;
    }

    public boolean smtpAuth() {
        return smtpAuth;
    }

    public EmailConfig smtpAuth(boolean smtpAuth) {
        this.smtpAuth = smtpAuth;
        return this;
    }

    public boolean enabled() {
        return enabled;
    }

    public EmailConfig enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }


}
