package com.andaily.hb.domain.notify;

import com.andaily.hb.domain.AbstractDomain;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;

import java.io.Serial;

/**
 * 2024/1/9 00:22
 * <p>
 * 钉钉机器人提醒设置
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
@Entity
@Table(name = "dingtalk_robot_config")
public class DingtalkRobotConfig extends AbstractDomain {
    @Serial
    private static final long serialVersionUID = -8846202771463737587L;


    /**
     * 是否启用提醒,
     * 默认 false
     */
    @Column(name = "enabled")
    private boolean enabled;

    /**
     * 钉钉 机器人 webhook
     * 相关文档 see https://developers.dingtalk.com/document/app/custom-robot-access/title-jfe-yo9-jl2
     */
    @Column(name = "robot_webhook")
    private String robotWebhook = "https://oapi.dingtalk.com/robot/send?access_token=xxx";


    /**
     * 发给钉钉机器人的 提醒内容
     * 支持模板变量
     */
    @Column(name = "notify_content")
    private String notifyContent;


    /**
     * At 钉钉人员的 手机号， 可选。
     * 多个用 逗号分隔
     */
    @Column(name = "phones")
    private String phones;

    /**
     * At 钉钉群里的所有人，可选
     * 默认 false
     */
    @Column(name = "at_all")
    private boolean atAll;


    public DingtalkRobotConfig() {
    }


    public boolean enabled() {
        return enabled;
    }

    public DingtalkRobotConfig enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String robotWebhook() {
        return robotWebhook;
    }

    public DingtalkRobotConfig robotWebhook(String robotWebhook) {
        this.robotWebhook = robotWebhook;
        return this;
    }


    public String notifyContent() {
        return notifyContent;
    }

    public DingtalkRobotConfig notifyContent(String notifyContent) {
        this.notifyContent = notifyContent;
        return this;
    }

    public String phones() {
        return phones;
    }

    public DingtalkRobotConfig phones(String phones) {
        this.phones = phones;
        return this;
    }

    public boolean atAll() {
        return atAll;
    }

    public DingtalkRobotConfig atAll(boolean atAll) {
        this.atAll = atAll;
        return this;
    }
}
