package com.andaily.hb.domain.network;

import com.andaily.hb.domain.AbstractInstance;
import com.andaily.hb.domain.application.HeartBeatFrequency;
import com.andaily.hb.domain.user.User;
import jakarta.persistence.*;

import java.io.Serial;


/**
 * 2023/12/12 20:16
 * <p>
 * 网络实例  TCP/UDP
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
@Entity
@Table(name = "network_instance")
public class NetworkInstance extends AbstractInstance {
    @Serial
    private static final long serialVersionUID = -5081654571435937782L;

    /**
     * 类型
     */
    public enum Type {

        /**
         * TCP
         */
        TCP,
        /**
         * UDP
         */
        UDP;


        public boolean isTcp() {
            return TCP.equals(this);
        }

        public boolean isUdp() {
            return UDP.equals(this);
        }
    }

    /**
     * 服务器地址， ip或域名
     */
    @Column(name = "server_address")
    private String serverAddress;

    /**
     * TCP/UDP 请求端口
     */
    @Column(name = "server_port")
    private int serverPort;

    /**
     * TCP/UDP 类型
     */
    @Column(name = "type_")
    @Enumerated(value = EnumType.STRING)
    private Type type = Type.TCP;

    /**
     * 请求时发送的内容,
     * 空则随机发时间值
     */
    @Column(name = "send_content")
    private String sendContent;

    /**
     * 默认提醒的邮件地址
     * 若有多个请用英文分号(;)分隔
     */
    @Column(name = "email")
    private String email;


    /**
     * Schedule中的任务名称,
     * 当启用该监听任务时, 将会有唯一对应的jobName
     */
    @Column(name = "job_name")
    private String jobName;


    public NetworkInstance() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String[] emailAsArray() {
        return email.contains(";") ? email.split(";") : new String[]{email};
    }

    @Override
    public String monitorUri() {
        return serverAddress + ":" + serverPort;
    }


    public String sendContent() {
        return sendContent;
    }

    public NetworkInstance sendContent(String sendContent) {
        this.sendContent = sendContent;
        return this;
    }

    public String email() {
        return email;
    }

    public NetworkInstance email(String email) {
        this.email = email;
        return this;
    }

    public Type type() {
        return type;
    }

    public NetworkInstance type(Type type) {
        this.type = type;
        return this;
    }

    public String serverAddress() {
        return serverAddress;
    }

    public NetworkInstance serverAddress(String serverAddress) {
        this.serverAddress = serverAddress;
        return this;
    }

    public int serverPort() {
        return serverPort;
    }

    public NetworkInstance serverPort(int serverPort) {
        this.serverPort = serverPort;
        return this;
    }


    public NetworkInstance enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public NetworkInstance creator(User creator) {
        this.creator = creator;
        return this;
    }

    public String jobName() {
        return jobName;
    }

    public NetworkInstance jobName(String jobName) {
        this.jobName = jobName;
        return this;
    }


    public NetworkInstance instanceName(String instanceName) {
        this.instanceName = instanceName;
        return this;
    }

    public NetworkInstance maxConnectionSeconds(int maxConnectionSeconds) {
        this.maxConnectionSeconds = maxConnectionSeconds;
        return this;
    }

    public NetworkInstance privateInstance(boolean privateInstance) {
        this.privateInstance = privateInstance;
        return this;
    }

    public NetworkInstance continueFailedTimes(int continueFailedTimes) {
        this.continueFailedTimes = continueFailedTimes;
        return this;
    }

    public NetworkInstance useProxy(boolean useProxy) {
        this.useProxy = useProxy;
        return this;
    }

    /**
     * @since 3.0.0
     */
    public NetworkInstance groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }
    public NetworkInstance frequency(HeartBeatFrequency frequency) {
        this.frequency = frequency;
        return this;
    }

    public NetworkInstance remark(String remark) {
        this.remark = remark;
        return this;
    }

}
