package com.andaily.hb.domain.log.reminder;

import com.andaily.hb.domain.application.ApplicationInstance;
import com.andaily.hb.domain.log.FrequencyMonitorLog;
import com.andaily.hb.domain.network.NetworkInstance;
import com.andaily.hb.domain.shared.Application;
import com.andaily.hb.infrastructure.DateUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * 2016/5/19
 *
 * @author Shengzhao Li
 */
public abstract class AbstractPerMonitoringReminderSender implements PerMonitoringReminderSender {

    private static final String INSTANCE_MONITORING_URL = "monitoring/%s.hb";


    protected String instanceUrl(String instanceGuid) {
        String url = String.format(INSTANCE_MONITORING_URL, instanceGuid);
        return Application.host() + url;
    }


    protected Map<String, Object> contentModel(FrequencyMonitorLog monitorLog) {
        Map<String, Object> model = new HashMap<>();
        final ApplicationInstance instance = monitorLog.instance();
        if (instance != null) {
            model.put("instanceName", instance.instanceName());
            model.put("url", instance.monitorUrl());
            model.put("instanceUrl", instanceUrl(instance.guid()));
        } else {
            NetworkInstance networkInstance = monitorLog.networkInstance();
            model.put("instanceName", networkInstance.instanceName());
            model.put("url", networkInstance.serverAddress() + ":" + networkInstance.serverPort());
            model.put("instanceUrl", instanceUrl(networkInstance.guid()));
        }

        model.put("costTime", monitorLog.costTime());
        model.put("time", DateUtils.toDateText(monitorLog.createTime(), DateUtils.DEFAULT_DATE_TIME_FORMAT));
        model.put("host", Application.host());
        model.put("remark", monitorLog.remark());
        return model;
    }


}
