package com.andaily.hb.domain.log;

import com.andaily.hb.domain.AbstractDomain;
import com.andaily.hb.domain.application.ApplicationInstance;

import com.andaily.hb.domain.network.NetworkInstance;
import jakarta.persistence.*;

import java.io.Serial;
import java.util.Date;

/**
 * 14-11-23
 * 实例每一次监控的 日志
 * 这是由定时任务每一次执行后的结果
 *
 * @author Shengzhao Li
 */
@Entity
@Table(name = "frequency_monitor_log")
public class FrequencyMonitorLog extends AbstractDomain {

    @Serial
    private static final long serialVersionUID = 4517860393571033878L;
    /**
     * 所属应用实例
     */
    @ManyToOne
    @JoinColumn(name = "instance_id")
    private ApplicationInstance instance;

    /**
     * 所属网络实例
     *
     * @since 3.0.0
     */
    @ManyToOne
    @JoinColumn(name = "network_instance_id")
    private NetworkInstance networkInstance;

    /**
     * 是否正常
     * true 变正常
     * false 变异常
     */
    @Column(name = "normal")
    private boolean normal;

    /**
     * 消耗时间 ms
     */
    @Column(name = "cost_time")
    private long costTime;

    /**
     * 响应返回的数据长度: byte
     */
    @Column(name = "response_size")
    private long responseSize;


    //备注信息
    @Column(name = "remark")
    private String remark;

    //default
    public FrequencyMonitorLog() {
    }

    public ApplicationInstance instance() {
        return instance;
    }

    public FrequencyMonitorLog instance(ApplicationInstance instance) {
        this.instance = instance;
        return this;
    }

    /**
     * @since 3.0.0
     */
    public NetworkInstance networkInstance() {
        return networkInstance;
    }

    /**
     * @since 3.0.0
     */
    public FrequencyMonitorLog networkInstance(NetworkInstance networkInstance) {
        this.networkInstance = networkInstance;
        return this;
    }

    public boolean normal() {
        return normal;
    }

    public FrequencyMonitorLog normal(boolean normal) {
        this.normal = normal;
        return this;
    }

    public long costTime() {
        return costTime;
    }

    public FrequencyMonitorLog costTime(long costTime) {
        this.costTime = costTime;
        return this;
    }

    public String remark() {
        return remark;
    }

    public FrequencyMonitorLog remark(String remark) {
        this.remark = remark;
        return this;
    }

    public FrequencyMonitorLog createTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public long responseSize() {
        return responseSize;
    }

    public FrequencyMonitorLog responseSize(long responseSize) {
        this.responseSize = responseSize;
        return this;
    }


    @Override
    public String toString() {
        return "{" +
                "normal=" + normal +
                ", id=" + id +
                ", createTime=" + createTime +
                ", costTime=" + costTime +
                ", responseSize=" + responseSize +
                ", remark='" + remark + '\'' +
                '}';
    }
}
