package com.andaily.hb.domain.dto.notify;

import com.andaily.hb.domain.dto.AbstractDto;
import com.andaily.hb.domain.notify.EmailConfig;
import com.andaily.hb.infrastructure.AesUtils;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;

import java.io.Serial;

/**
 * 2023/12/4 14:51
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
public class EmailConfigFormDto extends AbstractDto {
    @Serial
    private static final long serialVersionUID = -8488737849747125549L;

    /**
     * SMTP host
     */
    @NotEmpty(message = "SMTP host 不能为空")
    private String hostName;

    /**
     * SMTP port
     */
    @Min(value = 1, message = "SMTP port 不能小于1")
    private int smtpPort;

    /**
     * 发送的邮件地址
     */
    @NotEmpty(message = "发送的邮件地址不能为空")
    private String sendEmail;

    /**
     * 邮箱密码
     * 加密保存
     */
    private String password;

    /**
     * true 使用SSL安全通道
     */
    private boolean smtpAuth = true;

    /**
     * 是否开启 默认开启
     */
    private boolean enabled = true;


    /**
     * 是否启用开发环境
     */
    private boolean developEnvironment;


    /**
     * 开发环境指定的邮箱地址
     */
    private String developEmail;


    /**
     * 是否使用新线程发送邮件
     * 默认不使用
     */
    private boolean sendMailUseThread;


    public EmailConfigFormDto() {
    }

    public EmailConfigFormDto(EmailConfig config) {
        super(config.guid());
        this.hostName = config.hostName();
        this.smtpPort = config.smtpPort();
        this.sendEmail = config.sendEmail();

//        this.password = AesUtils.decrypt(config.password());
        this.smtpAuth = config.smtpAuth();
        this.enabled = config.enabled();

        this.developEnvironment = config.developEnvironment();
        this.developEmail = config.developEmail();
        this.sendMailUseThread = config.sendMailUseThread();
    }


    public String getHostName() {
        return hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public int getSmtpPort() {
        return smtpPort;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public String getSendEmail() {
        return sendEmail;
    }

    public void setSendEmail(String sendEmail) {
        this.sendEmail = sendEmail;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isSmtpAuth() {
        return smtpAuth;
    }

    public void setSmtpAuth(boolean smtpAuth) {
        this.smtpAuth = smtpAuth;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isDevelopEnvironment() {
        return developEnvironment;
    }

    public void setDevelopEnvironment(boolean developEnvironment) {
        this.developEnvironment = developEnvironment;
    }

    public String getDevelopEmail() {
        return developEmail;
    }

    public void setDevelopEmail(String developEmail) {
        this.developEmail = developEmail;
    }

    public boolean isSendMailUseThread() {
        return sendMailUseThread;
    }

    public void setSendMailUseThread(boolean sendMailUseThread) {
        this.sendMailUseThread = sendMailUseThread;
    }
}
