package com.andaily.hb.domain.dto.notify;

import com.andaily.hb.domain.dto.AbstractDto;
import com.andaily.hb.domain.notify.DingtalkRobotConfig;
import jakarta.validation.constraints.NotEmpty;

import java.io.Serial;

/**
 * 2024/1/9 10:23
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
public class DingtalkRobotConfigFormDto extends AbstractDto {
    @Serial
    private static final long serialVersionUID = 7497086443449283043L;


    /**
     * 是否启用提醒,
     * 默认 false
     */
    private boolean enabled;

    /**
     * 钉钉 机器人 webhook
     * 相关文档 see https://developers.dingtalk.com/document/app/custom-robot-access/title-jfe-yo9-jl2
     */
    @NotEmpty(message = "Webhook 不能为空")
    private String robotWebhook;


    /**
     * 发给钉钉机器人的 提醒内容
     * 支持模板变量
     */
    @NotEmpty(message = "提醒内容 不能为空")
    private String notifyContent;


    /**
     * At 钉钉人员的 手机号， 可选。
     * 多个用 逗号分隔
     */
    private String phones;

    /**
     * At 钉钉群里的所有人，可选
     * 默认 false
     */
    private boolean atAll;


    public DingtalkRobotConfigFormDto() {
    }

    public DingtalkRobotConfigFormDto(DingtalkRobotConfig config) {
        this.atAll = config.atAll();
        this.enabled = config.enabled();
        this.robotWebhook = config.robotWebhook();

        this.notifyContent = config.notifyContent();
        this.phones = config.phones();
    }


    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getRobotWebhook() {
        return robotWebhook;
    }

    public void setRobotWebhook(String robotWebhook) {
        this.robotWebhook = robotWebhook;
    }

    public String getNotifyContent() {
        return notifyContent;
    }

    public void setNotifyContent(String notifyContent) {
        this.notifyContent = notifyContent;
    }

    public String getPhones() {
        return phones;
    }

    public void setPhones(String phones) {
        this.phones = phones;
    }

    public boolean isAtAll() {
        return atAll;
    }

    public void setAtAll(boolean atAll) {
        this.atAll = atAll;
    }
}
