package com.andaily.hb.domain.dto.network;

import com.andaily.hb.domain.application.HeartBeatFrequency;
import com.andaily.hb.domain.network.NetworkInstance;

import java.io.Serial;

/**
 * 2023/12/27 22:15
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
public class NetworkInstanceFormDto extends NetworkInstanceDto {


    @Serial
    private static final long serialVersionUID = 477079866363886921L;



    /**
     * 系统配置是否启用 proxy
     *
     * @since 2.0.1
     */
    private boolean proxyEnabled = false;


    public NetworkInstanceFormDto() {
        super();
        //set default max connection time 30
        this.maxConnectionSeconds = 30;
    }

    public NetworkInstanceFormDto(NetworkInstance instance) {
        super(instance);
    }


    public HeartBeatFrequency[] getFrequencies() {
        return HeartBeatFrequency.values();
    }

    public boolean isProxyEnabled() {
        return proxyEnabled;
    }

    public void setProxyEnabled(boolean proxyEnabled) {
        this.proxyEnabled = proxyEnabled;
    }
}
