package com.andaily.hb.domain.dto.network;

import com.andaily.hb.domain.application.HeartBeatFrequency;
import com.andaily.hb.domain.dto.AbstractDto;
import com.andaily.hb.domain.network.NetworkInstance;
import com.andaily.hb.domain.user.User;
import com.andaily.hb.infrastructure.DateUtils;

import java.io.Serial;
import java.util.ArrayList;
import java.util.List;

/**
 * 2023/12/27 21:45
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
public class NetworkInstanceDto extends AbstractDto {
    @Serial
    private static final long serialVersionUID = -3861042044716076490L;


    protected String createTime;

    protected String instanceName;

    /**
     * 连接时超时的时间
     * 0,表示无超时
     */
    protected int maxConnectionSeconds;

    /**
     * enabled or disabled
     * 是否启用
     */
    protected boolean enabled;

    /**
     * 心跳检测频率, 默认30秒
     */
    protected HeartBeatFrequency frequency;


    /**
     * 备注信息
     */
    protected String remark;


    protected String creatorName;

    protected String creatorGuid;


    /**
     * 是否为私有应用, 私有应用只有自己登录后才能查看,
     * 别人不能看见, 默认为false,公开
     * <p/>
     * From Version 0.5
     */
    protected boolean privateInstance;


    /**
     * 当连续连接失败 指定的次数后才发送提醒.
     * 这用于处理有时连接在检测链接状态的时候，不要发现一次链接故障的时候就马上发邮件通知，
     * 这个过程可能因为网络故障（如常见的：丢包、dns故障）而出现问题
     * <p/>
     * 默认为连续2次
     */
    protected int continueFailedTimes = 2;


    /**
     * 如果系统开启了代理proxy,
     * 允许每个实例开启/关闭 是否使用proxy
     *
     * @since 2.0.1
     */
    protected boolean useProxy;

    /**
     * 服务器地址， ip或域名
     */
    private String serverAddress;

    /**
     * TCP/UDP 请求端口
     */
    private int serverPort;

    /**
     * TCP/UDP 类型
     */
    private NetworkInstance.Type type = NetworkInstance.Type.TCP;

    /**
     * 请求时发送的内容,
     * 空则随机发时间值
     */
    private String sendContent;

    /**
     * 默认提醒的邮件地址
     * 若有多个请用英文分号(;)分隔
     */
    private String email;


    /**
     * 分组标识
     *
     * @since 3.0.0
     */
    private String groupId;


    public NetworkInstanceDto() {
    }


    public NetworkInstanceDto(NetworkInstance instance) {
        super(instance.guid());
        this.instanceName = instance.instanceName();
        this.maxConnectionSeconds = instance.maxConnectionSeconds();

        this.enabled = instance.enabled();
        this.frequency = instance.frequency();
        this.remark = instance.remark();

        User creator = instance.creator();
        this.creatorName = creator.username();
        this.creatorGuid = creator.guid();

        this.privateInstance = instance.privateInstance();
        this.continueFailedTimes = instance.continueFailedTimes();
        this.useProxy = instance.useProxy();

        this.serverAddress = instance.serverAddress();
        this.serverPort = instance.serverPort();
        this.type = instance.type();

        this.sendContent = instance.sendContent();
        this.email = instance.email();
        this.createTime = DateUtils.toDateTime(instance.createTime());

        this.groupId = instance.groupId();
    }

    public static List<NetworkInstanceDto> toDtos(List<NetworkInstance> list) {
        List<NetworkInstanceDto> dtos = new ArrayList<>(list.size());
        for (NetworkInstance instance : list) {
            dtos.add(new NetworkInstanceDto(instance));
        }
        return dtos;
    }

    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getInstanceName() {
        return instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public int getMaxConnectionSeconds() {
        return maxConnectionSeconds;
    }

    public void setMaxConnectionSeconds(int maxConnectionSeconds) {
        this.maxConnectionSeconds = maxConnectionSeconds;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public HeartBeatFrequency getFrequency() {
        return frequency;
    }

    public void setFrequency(HeartBeatFrequency frequency) {
        this.frequency = frequency;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getCreatorName() {
        return creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public String getCreatorGuid() {
        return creatorGuid;
    }

    public void setCreatorGuid(String creatorGuid) {
        this.creatorGuid = creatorGuid;
    }

    public boolean isPrivateInstance() {
        return privateInstance;
    }

    public void setPrivateInstance(boolean privateInstance) {
        this.privateInstance = privateInstance;
    }

    public int getContinueFailedTimes() {
        return continueFailedTimes;
    }

    public void setContinueFailedTimes(int continueFailedTimes) {
        this.continueFailedTimes = continueFailedTimes;
    }

    public boolean isUseProxy() {
        return useProxy;
    }

    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    public String getServerAddress() {
        return serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public int getServerPort() {
        return serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public NetworkInstance.Type getType() {
        return type;
    }

    public void setType(NetworkInstance.Type type) {
        this.type = type;
    }

    public String getSendContent() {
        return sendContent;
    }

    public void setSendContent(String sendContent) {
        this.sendContent = sendContent;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }
}
