package com.andaily.hb.domain.dto.log;

import com.andaily.hb.domain.dto.CommonsInstanceDto;
import com.andaily.hb.domain.shared.paginated.DefaultPaginated;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 15-3-14
 *
 * @author Shengzhao Li
 */
public class ReminderLogListDto extends DefaultPaginated<MonitoringReminderLogDto> {


    private String instanceGuid;
    /**
     * 1 is un-normal -> normal,
     * 0 is normal -> un-normal ,
     * otherwise all
     */
    private int normal = -1;


    private int cleanMonitorLogFrequency;


    private List<CommonsInstanceDto> instanceDtos = new ArrayList<>();


    /**
     * 标识是否为 网络实例
     *
     * @since 3.0.0
     */
    private boolean networkInstance;
    /**
     * 分组标识
     *
     * @since 3.0.0
     */
    private String groupId;


    public ReminderLogListDto() {
    }


    @Override
    public Map<String, Object> queryMap() {
        final Map<String, Object> map = super.queryMap();
        map.put("instanceGuid", instanceGuid);
        map.put("normal", normal);
        return map;
    }

    public CommonsInstanceDto getInstanceDto() {
        if (StringUtils.isNotEmpty(instanceGuid)) {
            for (CommonsInstanceDto instanceDto : instanceDtos) {
                if (instanceDto.getGuid().equals(instanceGuid)) {
                    return instanceDto;
                }
            }
        }
        return null;
    }

    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getInstanceGuid() {
        return instanceGuid;
    }

    public void setInstanceGuid(String instanceGuid) {
        this.instanceGuid = instanceGuid;
    }

    public int getNormal() {
        return normal;
    }

    public void setNormal(int normal) {
        this.normal = normal;
    }

    public List<CommonsInstanceDto> getInstanceDtos() {
        return instanceDtos;
    }

    public void setInstanceDtos(List<CommonsInstanceDto> instanceDtos) {
        this.instanceDtos = instanceDtos;
    }

    public int getCleanMonitorLogFrequency() {
        return cleanMonitorLogFrequency;
    }

    public void setCleanMonitorLogFrequency(int cleanMonitorLogFrequency) {
        this.cleanMonitorLogFrequency = cleanMonitorLogFrequency;
    }

    public boolean isNetworkInstance() {
        return networkInstance;
    }

    public void setNetworkInstance(boolean networkInstance) {
        this.networkInstance = networkInstance;
    }
}
